/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.client.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.openejb.client.proxy.InvocationHandler;
import org.openejb.client.proxy.Jdk13InvocationHandler;
import org.openejb.client.proxy.ProxyFactory;

public class Jdk13ProxyFactory
implements ProxyFactory {
    private final Class[] constructorParams = new Class[]{java.lang.reflect.InvocationHandler.class};

    public void init(Properties props) {
        String version = "";
        String badVersion = "1.3.0-";
        try {
            version = System.getProperty("java.vm.version");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (version.indexOf(badVersion) != -1) {
            String message = "INCOMPATIBLE VM: \n\nThe Java Virtual Machine you are using contains a bug\nin the proxy generation logic.  This bug has been    \ndocumented by Sun and has been fixed in later VMs.   \nPlease download the latest 1.3 Virtual Machine.      \nFor more details see:                                \nhttp://developer.java.sun.com/developer/bugParade/bugs/4346224.html\n  ";
            throw new RuntimeException(message);
        }
    }

    public InvocationHandler getInvocationHandler(Object proxy) throws IllegalArgumentException {
        Jdk13InvocationHandler handler = (Jdk13InvocationHandler)Proxy.getInvocationHandler(proxy);
        if (handler == null) {
            return null;
        }
        return handler.getInvocationHandler();
    }

    public Object setInvocationHandler(Object proxy, InvocationHandler handler) throws IllegalArgumentException {
        Jdk13InvocationHandler jdk13 = (Jdk13InvocationHandler)Proxy.getInvocationHandler(proxy);
        if (jdk13 == null) {
            throw new IllegalArgumentException("Proxy " + proxy + " unknown!");
        }
        return jdk13.setInvocationHandler(handler);
    }

    public Class getProxyClass(Class interfce) throws IllegalArgumentException {
        return Proxy.getProxyClass(interfce.getClassLoader(), interfce);
    }

    public Class getProxyClass(Class[] interfaces) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("There must be at least one interface to implement.");
        }
        return Proxy.getProxyClass(interfaces[0].getClassLoader(), interfaces);
    }

    public boolean isProxyClass(Class cl) {
        return Proxy.isProxyClass(cl);
    }

    public Object newProxyInstance(Class proxyClass) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(proxyClass)) {
            throw new IllegalArgumentException("This class is not a proxy.");
        }
        try {
            Constructor cons = proxyClass.getConstructor(this.constructorParams);
            return cons.newInstance(new Jdk13InvocationHandler());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InstantiationException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    public Object newProxyInstance(Class interfce, InvocationHandler h) throws IllegalArgumentException {
        Jdk13InvocationHandler handler = new Jdk13InvocationHandler(h);
        return Proxy.newProxyInstance(interfce.getClassLoader(), new Class[]{interfce}, (java.lang.reflect.InvocationHandler)handler);
    }

    public Object newProxyInstance(Class[] interfaces, InvocationHandler h) throws IllegalArgumentException {
        if (interfaces.length < 1) {
            throw new IllegalArgumentException("There must be at least one interface to implement.");
        }
        Jdk13InvocationHandler handler = new Jdk13InvocationHandler(h);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (java.lang.reflect.InvocationHandler)handler);
    }
}

