/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core;

import java.util.HashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import org.openejb.Container;
import org.openejb.DeploymentInfo;
import org.openejb.core.ivm.naming.IvmContext;
import org.openejb.core.ivm.naming.ObjectReference;
import org.openejb.core.ivm.naming.Reference;
import org.openejb.core.stateful.EncReference;

public class ContainerSystem
implements org.openejb.spi.ContainerSystem {
    HashMap deployments = new HashMap();
    HashMap containers = new HashMap();
    IvmContext jndiRootContext = null;

    public ContainerSystem() {
        try {
            this.jndiRootContext = IvmContext.createRootContext();
            this.jndiRootContext.createSubcontext("java:openejb/ejb");
        }
        catch (NamingException exception) {
            throw new RuntimeException();
        }
    }

    public DeploymentInfo getDeploymentInfo(Object id) {
        return (DeploymentInfo)this.deployments.get(id);
    }

    public DeploymentInfo[] deployments() {
        return this.deployments.values().toArray(new DeploymentInfo[this.deployments.size()]);
    }

    public Container getContainer(Object id) {
        return (Container)this.containers.get(id);
    }

    public Container[] containers() {
        return this.containers.values().toArray(new Container[this.containers.size()]);
    }

    public void addContainer(Object id, Container c) {
        this.containers.put(id, c);
    }

    public void addDeployment(org.openejb.core.DeploymentInfo deployment) {
        this.deployments.put(deployment.getDeploymentID(), deployment);
        if (deployment.getHomeInterface() != null) {
            this.bindProxy(deployment, deployment.getEJBHome(), false);
        }
        if (deployment.getLocalHomeInterface() != null) {
            this.bindProxy(deployment, deployment.getEJBLocalHome(), true);
        }
    }

    private void bindProxy(org.openejb.core.DeploymentInfo deployment, Object proxy, boolean isLocal) {
        Reference ref = new ObjectReference(proxy);
        ref = deployment.getComponentType() == 6 ? new EncReference(ref) : (deployment.getComponentType() == 7 ? new org.openejb.core.stateless.EncReference(ref) : new org.openejb.core.entity.EncReference(ref));
        try {
            String bindName = deployment.getDeploymentID().toString();
            if (bindName.charAt(0) == '/') {
                bindName = bindName.substring(1);
            }
            bindName = "openejb/ejb/" + bindName;
            if (isLocal) {
                bindName = bindName + "Local";
            }
            this.jndiRootContext.bind(bindName, (Object)ref);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public Context getJNDIContext() {
        return this.jndiRootContext;
    }
}

