/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core;

import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.openejb.OpenEJB;
import org.openejb.RpcContainer;
import org.openejb.core.CoreUserTransaction;
import org.openejb.core.DeploymentInfo;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.EjbObjectProxyHandler;
import org.openejb.core.ivm.IntraVmProxy;
import org.openejb.util.proxy.InvocationHandler;
import org.openejb.util.proxy.ProxyManager;

public abstract class CoreContext
implements Serializable {
    public static final byte SECURITY_METHOD = 1;
    public static final byte USER_TRANSACTION_METHOD = 2;
    public static final byte ROLLBACK_METHOD = 3;
    public static final byte EJBOBJECT_METHOD = 4;
    public static final byte EJBHOME_METHOD = 5;
    CoreUserTransaction userTransaction = new CoreUserTransaction(OpenEJB.getTransactionManager());

    public abstract void checkBeanState(byte var1) throws IllegalStateException;

    public Principal getCallerPrincipal() {
        this.checkBeanState((byte)1);
        Object securityIdentity = ThreadContext.getThreadContext().getSecurityIdentity();
        return (Principal)OpenEJB.getSecurityService().translateTo(securityIdentity, Principal.class);
    }

    public boolean isCallerInRole(String roleName) {
        this.checkBeanState((byte)1);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        String[] physicalRoles = di.getPhysicalRole(roleName);
        Object caller = threadContext.getSecurityIdentity();
        return OpenEJB.getSecurityService().isCallerAuthorized(caller, physicalRoles);
    }

    public EJBHome getEJBHome() {
        this.checkBeanState((byte)5);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        return di.getEJBHome();
    }

    public EJBObject getEJBObject() {
        this.checkBeanState((byte)4);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        EjbObjectProxyHandler handler = this.newEjbObjectHandler((RpcContainer)di.getContainer(), threadContext.getPrimaryKey(), di.getDeploymentID());
        Object newProxy = null;
        try {
            Class[] interfaces = new Class[]{di.getRemoteInterface(), IntraVmProxy.class};
            newProxy = ProxyManager.newProxyInstance(interfaces, (InvocationHandler)handler);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not create IVM proxy for " + di.getRemoteInterface() + " interface");
        }
        return (EJBObject)newProxy;
    }

    public EJBLocalObject getEJBLocalObject() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        EjbObjectProxyHandler handler = this.newEjbObjectHandler((RpcContainer)di.getContainer(), threadContext.getPrimaryKey(), di.getDeploymentID());
        handler.setLocal(true);
        Object newProxy = null;
        try {
            Class[] interfaces = new Class[]{di.getLocalInterface(), IntraVmProxy.class};
            newProxy = ProxyManager.newProxyInstance(interfaces, (InvocationHandler)handler);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not create IVM proxy for " + di.getLocalInterface() + " interface");
        }
        return (EJBLocalObject)newProxy;
    }

    public EJBLocalHome getEJBLocalHome() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        return di.getEJBLocalHome();
    }

    public TimerService getTimerService() {
        return null;
    }

    public Object getPrimaryKey() {
        this.checkBeanState((byte)4);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        return threadContext.getPrimaryKey();
    }

    public boolean getRollbackOnly() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        if (di.isBeanManagedTransaction()) {
            throw new IllegalStateException("bean-managed transaction beans can not access the getRollbackOnly( ) method");
        }
        this.checkBeanState((byte)3);
        try {
            int status = OpenEJB.getTransactionManager().getStatus();
            if (status == 1 || status == 4) {
                return true;
            }
            if (status == 6) {
                throw new IllegalStateException("No current transaction");
            }
            return false;
        }
        catch (SystemException se) {
            throw new RuntimeException("Transaction service has thrown a SystemException");
        }
    }

    public void setRollbackOnly() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        if (di.isBeanManagedTransaction()) {
            throw new IllegalStateException("bean-managed transaction beans can not access the setRollbackOnly( ) method");
        }
        this.checkBeanState((byte)3);
        try {
            OpenEJB.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException se) {
            throw new RuntimeException("Transaction service has thrown a SystemException");
        }
    }

    public UserTransaction getUserTransaction() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        DeploymentInfo di = threadContext.getDeploymentInfo();
        if (di.isBeanManagedTransaction()) {
            this.checkBeanState((byte)2);
            return this.userTransaction;
        }
        throw new IllegalStateException("container-managed transaction beans can not access the UserTransaction");
    }

    public boolean isCallerInRole(Identity role) {
        throw new UnsupportedOperationException();
    }

    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException();
    }

    public Properties getEnvironment() {
        throw new UnsupportedOperationException();
    }

    protected abstract EjbObjectProxyHandler newEjbObjectHandler(RpcContainer var1, Object var2, Object var3);
}

