/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.log4j.Category;
import org.openejb.OpenEJB;
import org.openejb.core.TransactionManagerWrapper;

public class CoreUserTransaction
implements UserTransaction,
Serializable {
    private transient TransactionManager _txManager;
    private final transient Category txLogger;

    public CoreUserTransaction(TransactionManager txMngr) {
        this._txManager = txMngr;
        this.txLogger = Category.getInstance((String)"Transaction");
    }

    public CoreUserTransaction() {
        this(OpenEJB.getTransactionManager());
    }

    private TransactionManager transactionManager() {
        if (this._txManager == null) {
            this._txManager = OpenEJB.getTransactionManager();
        }
        return this._txManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager().begin();
        if (this.txLogger.isInfoEnabled()) {
            this.txLogger.info((Object)("Started user transaction " + this.transactionManager().getTransaction()));
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.txLogger.isInfoEnabled()) {
            this.txLogger.info((Object)("Committing user transaction " + this.transactionManager().getTransaction()));
        }
        this.transactionManager().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this.txLogger.isInfoEnabled()) {
            this.txLogger.info((Object)("Rolling back user transaction " + this.transactionManager().getTransaction()));
        }
        this.transactionManager().rollback();
    }

    public int getStatus() throws SystemException {
        int status = this.transactionManager().getStatus();
        if (this.txLogger.isInfoEnabled()) {
            this.txLogger.info((Object)("User transaction " + this.transactionManager().getTransaction() + " has status " + TransactionManagerWrapper.getStatus(status)));
        }
        return status;
    }

    public void setRollbackOnly() throws SystemException {
        if (this.txLogger.isInfoEnabled()) {
            this.txLogger.info((Object)("Marking user transaction for rollback: " + this.transactionManager().getTransaction()));
        }
        this.transactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.transactionManager().setTransactionTimeout(seconds);
    }
}

