/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core;

import org.openejb.core.DeploymentInfo;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.FastThreadLocal;

public class ThreadContext
implements Cloneable {
    protected static FastThreadLocal threadStorage = new FastThreadLocal();
    protected static Class implClass = ThreadContext.class;
    protected boolean valid = false;
    protected DeploymentInfo deploymentInfo;
    protected Object primaryKey;
    protected byte currentOperation;
    protected Object securityIdentity;
    protected Object unspecified;

    protected static ThreadContext newThreadContext() {
        try {
            return (ThreadContext)implClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("ThreadContext implemenation class could not be instantiated. Class type = " + implClass + " exception message = " + e.getMessage());
        }
    }

    public static boolean isValid() {
        ThreadContext tc = (ThreadContext)threadStorage.get();
        if (tc != null) {
            return tc.valid;
        }
        return false;
    }

    protected void makeInvalid() {
        this.valid = false;
        this.deploymentInfo = null;
        this.primaryKey = null;
        this.currentOperation = 0;
        this.securityIdentity = null;
        this.unspecified = null;
    }

    public static void invalidate() {
        ThreadContext tc = (ThreadContext)threadStorage.get();
        if (tc != null) {
            tc.makeInvalid();
        }
    }

    public static void setThreadContext(ThreadContext tc) {
        if (tc == null) {
            tc = (ThreadContext)threadStorage.get();
            if (tc != null) {
                tc.makeInvalid();
            }
        } else {
            threadStorage.set(tc);
        }
    }

    public static ThreadContext getThreadContext() {
        ThreadContext tc = (ThreadContext)threadStorage.get();
        if (tc == null) {
            tc = ThreadContext.newThreadContext();
            threadStorage.set(tc);
        }
        return tc;
    }

    public byte getCurrentOperation() {
        return this.currentOperation;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public DeploymentInfo getDeploymentInfo() {
        return this.deploymentInfo;
    }

    public Object getSecurityIdentity() {
        return this.securityIdentity;
    }

    public Object getUnspecified() {
        return this.unspecified;
    }

    public void set(DeploymentInfo di, Object primKey, Object securityIdentity) {
        this.setDeploymentInfo(di);
        this.setPrimaryKey(primKey);
        this.setSecurityIdentity(securityIdentity);
        this.valid = true;
    }

    public void setCurrentOperation(byte op) {
        this.currentOperation = op;
        this.valid = true;
    }

    public void setPrimaryKey(Object primKey) {
        this.primaryKey = primKey;
        this.valid = true;
    }

    public void setSecurityIdentity(Object identity) {
        this.securityIdentity = identity;
        this.valid = true;
    }

    public void setDeploymentInfo(DeploymentInfo info) {
        this.deploymentInfo = info;
    }

    public void setUnspecified(Object obj) {
        this.unspecified = obj;
    }

    public boolean valid() {
        return this.valid;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static {
        String className = System.getProperty("org/openejb/core/ThreadContext/IMPL_CLASS");
        if (className == null) {
            className = System.getProperty("org/openejb/core/ThreadContext/IMPL_CLASS");
        }
        if (className != null) {
            try {
                ClassLoader cl = ClasspathUtils.getContextClassLoader();
                implClass = Class.forName(className, true, cl);
            }
            catch (Exception e) {
                System.out.println("Can not load ThreadContext class. org.openejb.core.threadcontext_class = " + className);
                e.printStackTrace();
                implClass = null;
            }
        }
    }
}

