/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core;

import java.util.Hashtable;
import java.util.Vector;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Category;

public class TransactionManagerWrapper
implements TransactionManager {
    private final TransactionManager transactionManager;
    private final Hashtable wrapperMap = new Hashtable();
    protected static final Category logger = Category.getInstance((String)"Transaction");

    public TransactionManagerWrapper(TransactionManager txMngr) {
        this.transactionManager = txMngr;
    }

    public TransactionManager getTxManager() {
        return this.transactionManager;
    }

    public void begin() throws SystemException, NotSupportedException {
        int status = this.transactionManager.getStatus();
        if (status != 6 && status != 4 && status != 3) {
            throw new NotSupportedException("Can't start new transaction." + TransactionManagerWrapper.getStatus(status));
        }
        this.transactionManager.begin();
        this.createTxWrapper();
    }

    public void commit() throws SystemException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
        this.transactionManager.commit();
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getTxWrapper(this.transactionManager.getTransaction());
    }

    public void resume(Transaction tx) throws SystemException, InvalidTransactionException {
        if (tx instanceof TransactionWrapper) {
            tx = ((TransactionWrapper)tx).transaction;
        }
        this.transactionManager.resume(tx);
    }

    public Transaction suspend() throws SystemException {
        return this.getTxWrapper(this.transactionManager.suspend());
    }

    public void rollback() throws SystemException {
        this.transactionManager.rollback();
    }

    public void setRollbackOnly() throws SystemException {
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int x) throws SystemException {
        this.transactionManager.setTransactionTimeout(x);
    }

    private Transaction getTxWrapper(Transaction tx) throws SystemException {
        if (tx == null) {
            return null;
        }
        return (TransactionWrapper)this.wrapperMap.get(tx);
    }

    private void createTxWrapper() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            TransactionWrapper txW = new TransactionWrapper(tx);
            tx.registerSynchronization((Synchronization)txW);
            this.wrapperMap.put(tx, txW);
        }
        catch (Exception re) {
            logger.info((Object)"", (Throwable)re);
        }
    }

    public static String getStatus(int status) {
        StringBuffer buffer = new StringBuffer(100);
        switch (status) {
            case 0: {
                buffer.append("STATUS_ACTIVE: ");
                buffer.append("A transaction is associated with the target object and it is in the active state.");
                break;
            }
            case 3: {
                buffer.append("STATUS_COMMITTED: ");
                buffer.append("A transaction is associated with the target object and it has been committed.");
                break;
            }
            case 8: {
                buffer.append("STATUS_COMMITTING: ");
                buffer.append("A transaction is associated with the target object and it is in the process of committing.");
                break;
            }
            case 1: {
                buffer.append("STATUS_MARKED_ROLLBACK: ");
                buffer.append("A transaction is associated with the target object and it has been marked for rollback, perhaps as a result of a setRollbackOnly operation.");
                break;
            }
            case 6: {
                buffer.append("STATUS_NO_TRANSACTION: ");
                buffer.append("No transaction is currently associated with the target object.");
                break;
            }
            case 2: {
                buffer.append("STATUS_PREPARED: ");
                buffer.append("A transaction is associated with the target object and it has been prepared, i.e.");
                break;
            }
            case 7: {
                buffer.append("STATUS_PREPARING: ");
                buffer.append("A transaction is associated with the target object and it is in the process of preparing.");
                break;
            }
            case 4: {
                buffer.append("STATUS_ROLLEDBACK: ");
                buffer.append("A transaction is associated with the target object and the outcome has been determined as rollback.");
                break;
            }
            case 9: {
                buffer.append("STATUS_ROLLING_BACK: ");
                buffer.append("A transaction is associated with the target object and it is in the process of rolling back.");
                break;
            }
            default: {
                buffer.append("Unknown status " + status);
            }
        }
        return buffer.toString();
    }

    private class TransactionWrapper
    implements Transaction,
    Synchronization {
        private final Transaction transaction;
        private final Vector registeredSynchronizations;
        public static final int MAX_PRIORITY_LEVEL = 3;

        private TransactionWrapper(Transaction tx) {
            this.transaction = tx;
            this.registeredSynchronizations = new Vector();
        }

        public Transaction getTransaction() {
            return this.transaction;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof TransactionWrapper) {
                return this.transaction.equals(((TransactionWrapper)obj).getTransaction());
            }
            return false;
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }

        public String toString() {
            return this.transaction.toString();
        }

        public void commit() throws SystemException, RollbackException, HeuristicRollbackException, HeuristicMixedException {
            this.transaction.commit();
        }

        public boolean delistResource(XAResource xaRes, int flag) throws SystemException {
            return this.transaction.delistResource(xaRes, flag);
        }

        public boolean enlistResource(XAResource xaRes) throws SystemException, RollbackException {
            return this.transaction.enlistResource(xaRes);
        }

        public int getStatus() throws SystemException {
            return this.transaction.getStatus();
        }

        public void registerSynchronization(Synchronization sync) throws SystemException, RollbackException {
            this.registerSynchronization(sync, 3);
        }

        private void registerSynchronization(Synchronization sync, int priority) {
            if (!this.registeredSynchronizations.contains(sync)) {
                this.registeredSynchronizations.addElement(sync);
            }
        }

        public void rollback() throws SystemException {
            this.transaction.rollback();
        }

        public void setRollbackOnly() throws SystemException {
            this.transaction.setRollbackOnly();
        }

        public void beforeCompletion() {
            int count = this.registeredSynchronizations.size();
            for (int i = 0; i < count; ++i) {
                try {
                    Synchronization sync = (Synchronization)this.registeredSynchronizations.elementAt(i);
                    sync.beforeCompletion();
                    continue;
                }
                catch (RuntimeException re) {
                    logger.error((Object)"", (Throwable)re);
                }
            }
        }

        public void afterCompletion(int status) {
            int count = this.registeredSynchronizations.size();
            for (int i = 0; i < count; ++i) {
                try {
                    Synchronization sync = (Synchronization)this.registeredSynchronizations.elementAt(i);
                    sync.afterCompletion(status);
                    continue;
                }
                catch (RuntimeException re) {
                    logger.error((Object)"", (Throwable)re);
                }
            }
            TransactionManagerWrapper.this.wrapperMap.remove(this.transaction);
        }
    }
}

