/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.entity;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.EntityBean;
import javax.transaction.Transaction;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.entity.EntityInstanceManager;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;
import org.openejb.util.ArrayEnumeration;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.Logger;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;

public class EntityContainer
implements RpcContainer,
TransactionContainer {
    protected EntityInstanceManager instanceManager;
    protected HashMap deploymentRegistry;
    protected Object containerID = null;
    public Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");

    public void init(Object id, HashMap registry, Properties properties) throws OpenEJBException {
        this.containerID = id;
        this.deploymentRegistry = registry;
        if (properties == null) {
            properties = new Properties();
        }
        SafeToolkit toolkit = SafeToolkit.getToolkit("EntityContainer");
        SafeProperties safeProps = toolkit.getSafeProperties(properties);
        try {
            String className = safeProps.getProperty("InstanceManager", "org.openejb.core.entity.EntityInstanceManager");
            ClassLoader cl = ClasspathUtils.getContextClassLoader();
            this.instanceManager = (EntityInstanceManager)Class.forName(className, true, cl).newInstance();
        }
        catch (Exception e) {
            throw new SystemException("Initialization of InstanceManager for the \"" + this.containerID + "\" entity container failed", e);
        }
        this.instanceManager.init(this, registry, properties);
        DeploymentInfo[] deploys = this.deployments();
        for (int x = 0; x < deploys.length; ++x) {
            org.openejb.core.DeploymentInfo di = (org.openejb.core.DeploymentInfo)deploys[x];
            di.setContainer(this);
        }
    }

    public DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return (DeploymentInfo)this.deploymentRegistry.get(deploymentID);
    }

    public int getContainerType() {
        return 3;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public void deploy(Object deploymentID, DeploymentInfo info) throws OpenEJBException {
        HashMap registry = (HashMap)this.deploymentRegistry.clone();
        registry.put(deploymentID, info);
        this.deploymentRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        try {
            org.openejb.core.DeploymentInfo deployInfo = (org.openejb.core.DeploymentInfo)this.getDeploymentInfo(deployID);
            ThreadContext callContext = ThreadContext.getThreadContext();
            callContext.set(deployInfo, primKey, securityIdentity);
            boolean authorized = OpenEJB.getSecurityService().isCallerAuthorized(securityIdentity, deployInfo.getAuthorizedRoles(callMethod));
            if (!authorized) {
                throw new ApplicationException(new RemoteException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            String methodName = callMethod.getName();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (declaringClass != EJBHome.class && declaringClass != EJBLocalHome.class) {
                    if (methodName.equals("create")) {
                        ProxyInfo proxyInfo = this.createEJBObject(callMethod, args, callContext);
                        return proxyInfo;
                    }
                    if (methodName.startsWith("find")) {
                        Object object = this.findMethod(callMethod, args, callContext);
                        return object;
                    }
                    Object object = this.homeMethod(callMethod, args, callContext);
                    return object;
                }
                if (methodName.equals("remove")) {
                    this.removeEJBObject(callMethod, args, callContext);
                    Object var11_14 = null;
                    return var11_14;
                }
            } else if ((EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) && methodName.equals("remove")) {
                this.removeEJBObject(callMethod, args, callContext);
                Object var11_15 = null;
                return var11_15;
            }
            callContext.setCurrentOperation((byte)1);
            Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
            Object retValue = this.invoke(callMethod, runMethod, args, callContext);
            Object object = deployInfo.convertIfLocalReference(callMethod, retValue);
            return object;
        }
        finally {
            ThreadContext.setThreadContext(null);
        }
    }

    public EntityInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(Method callMethod, Method runMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        TransactionPolicy txPolicy = callContext.getDeploymentInfo().getTransactionPolicy(callMethod);
        TransactionContext txContext = new TransactionContext();
        txContext.callContext = callContext;
        EntityBean bean = null;
        txPolicy.beforeInvoke((EnterpriseBean)bean, txContext);
        Object returnValue = null;
        try {
            try {
                bean = this.instanceManager.obtainInstance(callContext);
            }
            catch (OpenEJBException e) {
                throw e.getRootCause();
            }
            this.ejbLoad_If_No_Transaction(callContext, bean);
            returnValue = runMethod.invoke((Object)bean, args);
            this.ejbStore_If_No_Transaction(callContext, bean);
            this.instanceManager.poolInstance(callContext, bean);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                txPolicy.handleSystemException(ite.getTargetException(), (EnterpriseBean)bean, txContext);
            } else {
                this.instanceManager.poolInstance(callContext, bean);
                txPolicy.handleApplicationException(ite.getTargetException(), txContext);
            }
        }
        catch (SystemException se) {
            txPolicy.handleSystemException(se.getRootCause(), (EnterpriseBean)bean, txContext);
        }
        catch (Throwable iae) {
            txPolicy.handleSystemException(iae, (EnterpriseBean)bean, txContext);
        }
        finally {
            txPolicy.afterInvoke((EnterpriseBean)bean, txContext);
        }
        return returnValue;
    }

    public void ejbLoad_If_No_Transaction(ThreadContext callContext, EntityBean bean) throws SystemException, Exception {
        byte orginalOperation = callContext.getCurrentOperation();
        if (orginalOperation == 1 || orginalOperation == 5) {
            Transaction currentTx = null;
            try {
                currentTx = OpenEJB.getTransactionManager().getTransaction();
            }
            catch (javax.transaction.SystemException se) {
                throw new SystemException("Transaction Manager failure", se);
            }
            if (currentTx == null) {
                callContext.setCurrentOperation((byte)14);
                try {
                    bean.ejbLoad();
                }
                catch (Exception e) {
                    this.instanceManager.discardInstance(callContext, bean);
                    throw e;
                }
                finally {
                    callContext.setCurrentOperation(orginalOperation);
                }
            }
        }
    }

    public void ejbStore_If_No_Transaction(ThreadContext callContext, EntityBean bean) throws Exception {
        byte currentOp = callContext.getCurrentOperation();
        if (currentOp == 1) {
            Transaction currentTx = null;
            try {
                currentTx = OpenEJB.getTransactionManager().getTransaction();
            }
            catch (javax.transaction.SystemException se) {
                throw new SystemException("Transaction Manager failure", se);
            }
            if (currentTx == null) {
                callContext.setCurrentOperation((byte)15);
                try {
                    bean.ejbStore();
                }
                catch (Exception e) {
                    this.instanceManager.discardInstance(callContext, bean);
                    throw e;
                }
                finally {
                    callContext.setCurrentOperation(currentOp);
                }
            }
        }
    }

    protected void didCreateBean(ThreadContext callContext, EntityBean bean) throws OpenEJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        org.openejb.core.DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation((byte)8);
        EntityBean bean = null;
        Object primaryKey = null;
        TransactionPolicy txPolicy = callContext.getDeploymentInfo().getTransactionPolicy(callMethod);
        TransactionContext txContext = new TransactionContext();
        txContext.callContext = callContext;
        txPolicy.beforeInvoke((EnterpriseBean)bean, txContext);
        try {
            bean = this.instanceManager.obtainInstance(callContext);
            Method ejbCreateMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
            primaryKey = ejbCreateMethod.invoke((Object)bean, args);
            callContext.setPrimaryKey(primaryKey);
            this.didCreateBean(callContext, bean);
            callContext.setCurrentOperation((byte)9);
            Method ejbPostCreateMethod = deploymentInfo.getMatchingPostCreateMethod(ejbCreateMethod);
            ejbPostCreateMethod.invoke((Object)bean, args);
            primaryKey = callContext.getPrimaryKey();
            callContext.setPrimaryKey(null);
            this.instanceManager.poolInstance(callContext, bean);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                txPolicy.handleSystemException(ite.getTargetException(), (EnterpriseBean)bean, txContext);
            } else {
                this.instanceManager.poolInstance(callContext, bean);
                txPolicy.handleApplicationException(ite.getTargetException(), txContext);
            }
        }
        catch (OpenEJBException e) {
            txPolicy.handleSystemException(e.getRootCause(), (EnterpriseBean)bean, txContext);
        }
        catch (Throwable e) {
            txPolicy.handleSystemException(e, (EnterpriseBean)bean, txContext);
        }
        finally {
            txPolicy.afterInvoke((EnterpriseBean)bean, txContext);
        }
        Class<?> callingClass = callMethod.getDeclaringClass();
        boolean isLocalInterface = EJBLocalHome.class.isAssignableFrom(callingClass);
        return new ProxyInfo((DeploymentInfo)deploymentInfo, primaryKey, isLocalInterface, (RpcContainer)this);
    }

    protected Object findMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        org.openejb.core.DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation((byte)12);
        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
        Serializable returnValue = this.invoke(callMethod, runMethod, args, callContext);
        Class<?> callingClass = callMethod.getDeclaringClass();
        boolean isLocalInterface = EJBLocalHome.class.isAssignableFrom(callingClass);
        if (returnValue instanceof Collection) {
            Iterator keys = ((Collection)((Object)returnValue)).iterator();
            Vector<ProxyInfo> proxies = new Vector<ProxyInfo>();
            while (keys.hasNext()) {
                Object primaryKey = keys.next();
                proxies.addElement(new ProxyInfo((DeploymentInfo)deploymentInfo, primaryKey, isLocalInterface, (RpcContainer)this));
            }
            returnValue = proxies;
        } else if (returnValue instanceof Enumeration) {
            Enumeration keys = (Enumeration)((Object)returnValue);
            Vector<ProxyInfo> proxies = new Vector<ProxyInfo>();
            while (keys.hasMoreElements()) {
                Object primaryKey = keys.nextElement();
                proxies.addElement(new ProxyInfo((DeploymentInfo)deploymentInfo, primaryKey, isLocalInterface, (RpcContainer)this));
            }
            returnValue = new ArrayEnumeration(proxies);
        } else {
            returnValue = new ProxyInfo((DeploymentInfo)deploymentInfo, (Object)returnValue, isLocalInterface, (RpcContainer)this);
        }
        return returnValue;
    }

    protected Object homeMethod(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        org.openejb.core.DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        callContext.setCurrentOperation((byte)13);
        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
        return this.invoke(callMethod, runMethod, args, callContext);
    }

    protected void didRemove(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        callContext.setCurrentOperation((byte)5);
        TransactionPolicy txPolicy = callContext.getDeploymentInfo().getTransactionPolicy(callMethod);
        TransactionContext txContext = new TransactionContext();
        txContext.callContext = callContext;
        EntityBean bean = null;
        txPolicy.beforeInvoke((EnterpriseBean)bean, txContext);
        Object returnValue = null;
        try {
            bean = this.instanceManager.obtainInstance(callContext);
            this.ejbLoad_If_No_Transaction(callContext, bean);
            bean.ejbRemove();
            this.didRemove(bean, callContext);
            this.instanceManager.poolInstance(callContext, bean);
        }
        catch (SystemException se) {
            txPolicy.handleSystemException(se.getRootCause(), (EnterpriseBean)bean, txContext);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                txPolicy.handleSystemException(e, (EnterpriseBean)bean, txContext);
            } else {
                this.instanceManager.poolInstance(callContext, bean);
                txPolicy.handleApplicationException(e, txContext);
            }
        }
        finally {
            txPolicy.afterInvoke((EnterpriseBean)bean, txContext);
        }
    }

    public void discardInstance(EnterpriseBean bean, ThreadContext threadContext) {
        if (bean != null) {
            try {
                this.instanceManager.discardInstance(threadContext, (EntityBean)bean);
            }
            catch (SystemException e) {
                this.logger.error("The instance manager encountered an unkown system exception while trying to discard the entity instance with primary key " + threadContext.getPrimaryKey());
            }
        }
    }
}

