/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.entity;

import java.lang.reflect.Method;
import org.openejb.Container;
import org.openejb.RpcContainer;
import org.openejb.core.ivm.EjbObjectProxyHandler;
import org.openejb.util.proxy.InvocationHandler;
import org.openejb.util.proxy.ProxyManager;

public class EntityEjbObjectHandler
extends EjbObjectProxyHandler {
    private Object registryId;

    public EntityEjbObjectHandler(RpcContainer container, Object pk, Object depID) {
        super(container, pk, depID);
    }

    public static Object getRegistryId(Object primKey, Object deployId, Container contnr) {
        return new RegistryEntry(primKey, deployId, contnr.getContainerID());
    }

    public Object getRegistryId() {
        if (this.registryId == null) {
            this.registryId = EntityEjbObjectHandler.getRegistryId(this.primaryKey, this.deploymentID, this.container);
        }
        return this.registryId;
    }

    protected Object getPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        return this.primaryKey;
    }

    protected Object isIdentical(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        InvocationHandler hndr = ProxyManager.getInvocationHandler(proxy);
        if (hndr instanceof EntityEjbObjectHandler) {
            EntityEjbObjectHandler handler = (EntityEjbObjectHandler)hndr;
            if (this.getRegistryId().equals(handler.getRegistryId())) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    protected Object remove(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        Object value = this.container.invoke(this.deploymentID, method, args, this.primaryKey, this.getThreadSpecificSecurityIdentity());
        EntityEjbObjectHandler.invalidateAllHandlers(this.getRegistryId());
        return value;
    }

    private static final class RegistryEntry {
        final Object primaryKey;
        final Object deploymentId;
        final Object containerId;

        RegistryEntry(Object primaryKey, Object deploymentId, Object containerId) {
            if (primaryKey == null || deploymentId == null || containerId == null) {
                throw new IllegalArgumentException();
            }
            this.primaryKey = primaryKey;
            this.deploymentId = deploymentId;
            this.containerId = containerId;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof RegistryEntry) {
                RegistryEntry otherEntry = (RegistryEntry)other;
                return this.primaryKey.equals(otherEntry.primaryKey) && this.deploymentId.equals(otherEntry.deploymentId) && this.containerId.equals(otherEntry.containerId);
            }
            return false;
        }

        public int hashCode() {
            return this.primaryKey.hashCode();
        }
    }
}

