/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.entity;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.NoSuchEntityException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.core.DeploymentInfo;
import org.openejb.core.ThreadContext;
import org.openejb.core.entity.EntityContainer;
import org.openejb.util.LinkedListStack;
import org.openejb.util.Logger;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;
import org.openejb.util.Stack;

public class EntityInstanceManager {
    protected int poolsize = 0;
    protected EntityContainer container;
    protected Hashtable txReadyPool = new Hashtable();
    protected HashMap poolMap = null;
    public Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("EntityInstanceManager");
    static /* synthetic */ Class class$org$openejb$core$entity$EntityInstanceManager$Key;

    public void init(EntityContainer myContainer, HashMap deployments, Properties props) throws OpenEJBException {
        SafeProperties safeProps = this.toolkit.getSafeProperties(props);
        this.poolsize = safeProps.getPropertyAsInt("PoolSize", 100);
        this.container = myContainer;
        this.poolMap = new HashMap();
        Iterator iterator = deployments.values().iterator();
        while (iterator.hasNext()) {
            this.poolMap.put(((DeploymentInfo)iterator.next()).getDeploymentID(), new LinkedListStack(this.poolsize / 2));
        }
    }

    public EntityBean obtainInstance(ThreadContext callContext) throws OpenEJBException {
        Transaction currentTx = null;
        try {
            currentTx = OpenEJB.getTransactionManager().getTransaction();
        }
        catch (javax.transaction.SystemException se) {
            this.logger.error("Transaction Manager getTransaction() failed.", se);
            throw new SystemException("TransactionManager failure");
        }
        Object primaryKey = callContext.getPrimaryKey();
        if (currentTx != null && primaryKey != null) {
            Key key = new Key(currentTx, callContext.getDeploymentInfo().getDeploymentID(), primaryKey);
            SyncronizationWrapper wrapper = (SyncronizationWrapper)this.txReadyPool.get(key);
            if (wrapper != null) {
                if (!wrapper.isAssociated()) {
                    throw new InvalidateReferenceException((Exception)new NoSuchEntityException("Entity not found: " + primaryKey));
                }
                if (callContext.getCurrentOperation() == 5) {
                    wrapper.disassociate();
                }
                if (wrapper.isAvailable()) {
                    return wrapper.getEntityBean();
                }
                DeploymentInfo depInfo = callContext.getDeploymentInfo();
                if (depInfo.isReentrant()) {
                    return wrapper.getEntityBean();
                }
                throw new ApplicationException(new RemoteException("Attempted reentrant access. Bean is not reentrant"));
            }
            EntityBean bean = this.getPooledInstance(callContext);
            wrapper = new SyncronizationWrapper(bean, key, false, callContext);
            if (callContext.getCurrentOperation() == 5) {
                wrapper.disassociate();
            }
            try {
                currentTx.registerSynchronization((Synchronization)wrapper);
            }
            catch (javax.transaction.SystemException se) {
                this.logger.error("Transaction Manager registerSynchronization() failed.", se);
                throw new SystemException(se);
            }
            catch (RollbackException re) {
                throw new ApplicationException((Exception)new TransactionRolledbackException(re.getMessage()));
            }
            this.loadingBean(bean, callContext);
            byte orginalOperation = callContext.getCurrentOperation();
            callContext.setCurrentOperation((byte)14);
            try {
                bean.ejbLoad();
            }
            catch (Exception e) {
                this.logger.error("Exception encountered during ejbLoad():", e);
                throw new OpenEJBException(e);
            }
            finally {
                callContext.setCurrentOperation(orginalOperation);
            }
            this.txReadyPool.put(key, wrapper);
            return bean;
        }
        return this.getPooledInstance(callContext);
    }

    protected void loadingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    protected void reusingBean(EntityBean bean, ThreadContext callContext) throws OpenEJBException {
    }

    protected EntityBean getPooledInstance(ThreadContext callContext) throws OpenEJBException {
        byte currentOp;
        DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Stack methodReadyPool = (Stack)this.poolMap.get(deploymentInfo.getDeploymentID());
        if (methodReadyPool == null) {
            throw new SystemException("Invalid deployment id " + deploymentInfo.getDeploymentID() + " for this container");
        }
        EntityBean bean = (EntityBean)methodReadyPool.pop();
        if (bean == null) {
            try {
                bean = (EntityBean)deploymentInfo.getBeanClass().newInstance();
            }
            catch (Exception e) {
                this.logger.error("Bean instantiation failed for class " + deploymentInfo.getBeanClass(), e);
                throw new SystemException(e);
            }
            currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation((byte)6);
            try {
                bean.setEntityContext((EntityContext)callContext.getDeploymentInfo().getEJBContext());
            }
            catch (Exception e) {
                this.logger.error("Bean callback method failed ", e);
                throw new ApplicationException(e);
            }
            finally {
                callContext.setCurrentOperation(currentOp);
            }
        }
        this.reusingBean(bean, callContext);
        if (callContext.getCurrentOperation() == 1 || callContext.getCurrentOperation() == 5) {
            currentOp = callContext.getCurrentOperation();
            callContext.setCurrentOperation((byte)10);
            try {
                bean.ejbActivate();
            }
            catch (Throwable e) {
                this.logger.error("Encountered exception during call to ejbActivate()", e);
                try {
                    Transaction tx = OpenEJB.getTransactionManager().getTransaction();
                    if (tx != null) {
                        tx.setRollbackOnly();
                        throw new ApplicationException((Exception)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbActivate() on the instance. Exception message = " + e.getMessage()));
                    }
                }
                catch (javax.transaction.SystemException se) {
                    this.logger.error("Transaction Manager getTransaction() failed.", se);
                    throw new SystemException(se);
                }
                throw new ApplicationException(new RemoteException("Exception thrown while attempting to call ejbActivate() on the instance. Exception message = " + e.getMessage()));
            }
            finally {
                callContext.setCurrentOperation(currentOp);
            }
        }
        return bean;
    }

    public void poolInstance(ThreadContext callContext, EntityBean bean) throws OpenEJBException {
        if (bean == null) {
            return;
        }
        Object primaryKey = callContext.getPrimaryKey();
        Transaction currentTx = null;
        try {
            currentTx = OpenEJB.getTransactionManager().getTransaction();
        }
        catch (javax.transaction.SystemException se) {
            this.logger.error("Transaction Manager getTransaction() failed.", se);
            throw new SystemException("TransactionManager failure");
        }
        if (currentTx != null && primaryKey != null) {
            Key key = new Key(currentTx, callContext.getDeploymentInfo().getDeploymentID(), primaryKey);
            SyncronizationWrapper wrapper = (SyncronizationWrapper)this.txReadyPool.get(key);
            if (wrapper != null) {
                if (callContext.getCurrentOperation() == 5) {
                    wrapper.disassociate();
                    Stack methodReadyPool = (Stack)this.poolMap.get(callContext.getDeploymentInfo().getDeploymentID());
                    methodReadyPool.push(bean);
                } else {
                    wrapper.setEntityBean(bean);
                }
            } else {
                wrapper = new SyncronizationWrapper(bean, key, true, callContext);
                try {
                    currentTx.registerSynchronization((Synchronization)wrapper);
                }
                catch (javax.transaction.SystemException se) {
                    this.logger.error("Transaction Manager registerSynchronization() failed.", se);
                    throw new SystemException(se);
                }
                catch (RollbackException re) {
                    throw new ApplicationException((Exception)new TransactionRolledbackException(re.getMessage()));
                }
                this.txReadyPool.put(key, wrapper);
            }
        } else {
            if (primaryKey != null && callContext.getCurrentOperation() != 5) {
                byte currentOp = callContext.getCurrentOperation();
                callContext.setCurrentOperation((byte)11);
                try {
                    bean.ejbPassivate();
                }
                catch (Throwable e) {
                    try {
                        Transaction tx = OpenEJB.getTransactionManager().getTransaction();
                        if (tx != null) {
                            tx.setRollbackOnly();
                            throw new ApplicationException((Exception)new TransactionRolledbackException("Reflection exception thrown while attempting to call ejbPassivate() on the instance. Exception message = " + e.getMessage()));
                        }
                    }
                    catch (javax.transaction.SystemException se) {
                        this.logger.error("Transaction Manager getTransaction() failed.", se);
                        throw new SystemException(se);
                    }
                    throw new ApplicationException(new RemoteException("Reflection exception thrown while attempting to call ejbPassivate() on the instance. Exception message = " + e.getMessage()));
                }
                finally {
                    callContext.setCurrentOperation(currentOp);
                }
            }
            Stack methodReadyPool = (Stack)this.poolMap.get(callContext.getDeploymentInfo().getDeploymentID());
            methodReadyPool.push(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        this.discardInstance(callContext, bean);
        byte currentOp = callContext.getCurrentOperation();
        callContext.setCurrentOperation((byte)7);
        try {
            bean.unsetEntityContext();
        }
        catch (Exception e) {
            this.logger.info(this.getClass().getName() + ".freeInstance: ignoring exception " + e + " on bean instance " + bean);
        }
        finally {
            callContext.setCurrentOperation(currentOp);
        }
    }

    public void discardInstance(ThreadContext callContext, EntityBean bean) throws SystemException {
        Transaction currentTx = null;
        try {
            currentTx = OpenEJB.getTransactionManager().getTransaction();
        }
        catch (javax.transaction.SystemException se) {
            this.logger.error("Transaction Manager getTransaction() failed.", se);
            throw new SystemException("TransactionManager failure");
        }
        if (currentTx != null) {
            if (callContext.getPrimaryKey() == null) {
                return;
            }
            Key key = new Key(currentTx, callContext.getDeploymentInfo().getDeploymentID(), callContext.getPrimaryKey());
            SyncronizationWrapper wrapper = (SyncronizationWrapper)this.txReadyPool.remove(key);
            if (wrapper != null) {
                wrapper.disassociate();
            }
        }
    }

    protected class SyncronizationWrapper
    implements Synchronization {
        private EntityBean bean;
        private boolean isAvailable;
        private boolean isAssociated;
        private final ThreadContext context;
        private final Key myIndex;

        public SyncronizationWrapper(EntityBean ebean, Key key, boolean available, ThreadContext ctx) throws OpenEJBException {
            if (ebean == null || ctx == null || key == null) {
                throw new IllegalArgumentException();
            }
            this.bean = ebean;
            this.isAvailable = available;
            this.myIndex = key;
            this.isAssociated = true;
            try {
                this.context = (ThreadContext)ctx.clone();
            }
            catch (CloneNotSupportedException e) {
                EntityInstanceManager.this.logger.error("Thread context class " + ctx.getClass() + " doesn't implement the Cloneable interface!", e);
                throw new OpenEJBException("Thread context class " + ctx.getClass() + " doesn't implement the Cloneable interface!");
            }
        }

        public void disassociate() {
            this.isAssociated = false;
        }

        public boolean isAssociated() {
            return this.isAssociated;
        }

        public synchronized boolean isAvailable() {
            return this.isAvailable;
        }

        public void setEntityBean(EntityBean ebean) {
            this.isAvailable = true;
            this.bean = ebean;
        }

        public EntityBean getEntityBean() {
            this.isAvailable = false;
            return this.bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            if (this.isAssociated) {
                ThreadContext currentContext = ThreadContext.getThreadContext();
                ThreadContext.setThreadContext(this.context);
                byte orginalOperation = this.context.getCurrentOperation();
                this.context.setCurrentOperation((byte)15);
                try {
                    this.bean.ejbStore();
                }
                catch (Exception re) {
                    EntityInstanceManager.this.logger.error("Exception occured during ejbStore()", re);
                    TransactionManager txmgr = OpenEJB.getTransactionManager();
                    try {
                        txmgr.setRollbackOnly();
                    }
                    catch (javax.transaction.SystemException se) {
                        EntityInstanceManager.this.logger.error("Transaction manager reported error during setRollbackOnly()", se);
                    }
                }
                finally {
                    ThreadContext.setThreadContext(currentContext);
                }
            }
        }

        public void afterCompletion(int status) {
            EntityInstanceManager.this.txReadyPool.remove(this.myIndex);
        }
    }

    public static class Key {
        private final Object deploymentID;
        private final Object primaryKey;
        private final Transaction transaction;

        public Key(Transaction tx, Object depID, Object prKey) {
            if (tx == null || depID == null || prKey == null) {
                throw new IllegalArgumentException();
            }
            this.transaction = tx;
            this.deploymentID = depID;
            this.primaryKey = prKey;
        }

        public Object getPK() {
            return this.primaryKey;
        }

        public int hashCode() {
            return this.transaction.hashCode() ^ this.deploymentID.hashCode() ^ this.primaryKey.hashCode();
        }

        public boolean equals(Object other) {
            if (other != null && other.getClass() == (class$org$openejb$core$entity$EntityInstanceManager$Key == null ? (class$org$openejb$core$entity$EntityInstanceManager$Key = EntityInstanceManager.class$("org.openejb.core.entity.EntityInstanceManager$Key")) : class$org$openejb$core$entity$EntityInstanceManager$Key)) {
                Key otherKey = (Key)other;
                if (otherKey.transaction.equals(this.transaction) && otherKey.deploymentID.equals(this.deploymentID) && otherKey.primaryKey.equals(this.primaryKey)) {
                    return true;
                }
            }
            return false;
        }
    }
}

