/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.openejb.ApplicationException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.core.DeploymentInfo;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.core.ivm.IntraVmProxy;
import org.openejb.util.proxy.InvocationHandler;
import org.openejb.util.proxy.ProxyManager;

public abstract class BaseEjbProxyHandler
implements InvocationHandler,
Serializable {
    protected static final Hashtable liveHandleRegistry = new Hashtable();
    public final Object deploymentID;
    public final Object primaryKey;
    public boolean inProxyMap = false;
    public transient DeploymentInfo deploymentInfo;
    public transient RpcContainer container;
    protected boolean isInvalidReference = false;
    protected boolean doIntraVmCopy;
    private boolean isLocal;

    public BaseEjbProxyHandler(RpcContainer container, Object pk, Object depID) {
        this.container = container;
        this.primaryKey = pk;
        this.deploymentID = depID;
        this.deploymentInfo = (DeploymentInfo)container.getDeploymentInfo(depID);
        String value = OpenEJB.getInitProps().getProperty("openejb.localcopy");
        if (value == null) {
            value = OpenEJB.getInitProps().getProperty("org/openejb/core/ivm/BaseEjbProxyHandler/INTRA_VM_COPY");
        }
        if (value == null) {
            value = System.getProperty("openejb.localcopy");
        }
        if (value == null) {
            value = System.getProperty("org/openejb/core/ivm/BaseEjbProxyHandler/INTRA_VM_COPY");
        }
        this.doIntraVmCopy = value == null || !value.equalsIgnoreCase("FALSE");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, NoSuchMethodException {
        in.defaultReadObject();
        this.deploymentInfo = (DeploymentInfo)OpenEJB.getDeploymentInfo(this.deploymentID);
        this.container = (RpcContainer)this.deploymentInfo.getContainer();
    }

    protected void checkAuthorization(Method method) throws OpenEJBException {
        Object caller = this.getThreadSpecificSecurityIdentity();
        boolean authorized = OpenEJB.getSecurityService().isCallerAuthorized(caller, this.deploymentInfo.getAuthorizedRoles(method));
        if (!authorized) {
            throw new ApplicationException(new RemoteException("Unauthorized Access by Principal Denied"));
        }
    }

    protected Object getThreadSpecificSecurityIdentity() {
        ThreadContext context = ThreadContext.getThreadContext();
        if (context.valid()) {
            return context.getSecurityIdentity();
        }
        return OpenEJB.getSecurityService().getSecurityIdentity();
    }

    public void setIntraVmCopyMode(boolean on) {
        this.doIntraVmCopy = on;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnObj2;
        String jndiEnc;
        boolean cntextValid;
        Object scrtyIdentity;
        byte crrntOperation;
        Object prmryKey;
        DeploymentInfo depInfo;
        ThreadContext cntext;
        block22: {
            Object object;
            block21: {
                if (this.isInvalidReference) {
                    throw new NoSuchObjectException("reference is invalid");
                }
                if (method.getDeclaringClass() == Object.class) {
                    Boolean bl;
                    String methodName = method.getName();
                    if (methodName.equals("toString")) {
                        return this.toString();
                    }
                    if (!methodName.equals("equals")) {
                        if (!methodName.equals("hashCode")) throw new UnsupportedOperationException("Unkown method: " + method);
                        return new Integer(this.hashCode());
                    }
                    if (this.equals(args[0])) {
                        bl = Boolean.TRUE;
                        return bl;
                    }
                    bl = Boolean.FALSE;
                    return bl;
                }
                if (method.getDeclaringClass() == IntraVmProxy.class) {
                    String methodName = method.getName();
                    if (!methodName.equals("writeReplace")) throw new UnsupportedOperationException("Unkown method: " + method);
                    return this._writeReplace(proxy);
                }
                cntext = null;
                depInfo = null;
                prmryKey = null;
                crrntOperation = 0;
                scrtyIdentity = null;
                cntextValid = false;
                cntext = ThreadContext.getThreadContext();
                if (cntext.valid()) {
                    depInfo = cntext.getDeploymentInfo();
                    prmryKey = cntext.getPrimaryKey();
                    crrntOperation = cntext.getCurrentOperation();
                    scrtyIdentity = cntext.getSecurityIdentity();
                    cntextValid = true;
                }
                jndiEnc = System.getProperty("java.naming.factory.url.pkgs");
                System.setProperty("java.naming.factory.url.pkgs", "org.openejb.core.ivm.naming");
                try {
                    if (this.doIntraVmCopy) {
                        if (args != null && args.length > 0) {
                            IntraVmCopyMonitor.preCopyOperation();
                            args = this.copyArgs(args);
                            IntraVmCopyMonitor.postCopyOperation();
                        }
                        Object returnObj2 = this._invoke(proxy, method, args);
                        IntraVmCopyMonitor.preCopyOperation();
                        object = returnObj2 = this.copyObj(returnObj2);
                        Object var15_19 = null;
                        break block21;
                    }
                    try {
                        returnObj2 = this._invoke(proxy, method, args);
                        break block22;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        Class<?>[] etypes = method.getExceptionTypes();
                        int i = 0;
                        while (true) {
                            if (i >= etypes.length) {
                                while (!(t instanceof RuntimeException)) {
                                    t = t.getCause();
                                }
                                throw t;
                            }
                            if (t.getClass().isAssignableFrom(etypes[i])) {
                                throw t;
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var15_21 = null;
                    System.setProperty("java.naming.factory.url.pkgs", jndiEnc);
                    if (cntextValid) {
                        cntext.set(depInfo, prmryKey, scrtyIdentity);
                        cntext.setCurrentOperation(crrntOperation);
                    }
                    if (!this.doIntraVmCopy) throw throwable;
                    IntraVmCopyMonitor.postCopyOperation();
                    throw throwable;
                }
            }
            System.setProperty("java.naming.factory.url.pkgs", jndiEnc);
            if (cntextValid) {
                cntext.set(depInfo, prmryKey, scrtyIdentity);
                cntext.setCurrentOperation(crrntOperation);
            }
            if (!this.doIntraVmCopy) return object;
            IntraVmCopyMonitor.postCopyOperation();
            return object;
        }
        Object var15_20 = null;
        System.setProperty("java.naming.factory.url.pkgs", jndiEnc);
        if (cntextValid) {
            cntext.set(depInfo, prmryKey, scrtyIdentity);
            cntext.setCurrentOperation(crrntOperation);
        }
        if (!this.doIntraVmCopy) return returnObj2;
        IntraVmCopyMonitor.postCopyOperation();
        return returnObj2;
    }

    public String toString() {
        return "proxy=" + this.getProxyInfo().getInterface().getName() + ";deployment=" + this.deploymentID + ";pk=" + this.primaryKey;
    }

    public int hashCode() {
        if (this.primaryKey == null) {
            return this.deploymentID.hashCode();
        }
        return this.primaryKey.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            obj = ProxyManager.getInvocationHandler(obj);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        BaseEjbProxyHandler other = (BaseEjbProxyHandler)obj;
        if (this.primaryKey == null) {
            return other.primaryKey == null && this.deploymentID.equals(other.deploymentID);
        }
        return this.primaryKey.equals(other.primaryKey) && this.deploymentID.equals(other.deploymentID);
    }

    protected abstract Object _invoke(Object var1, Method var2, Object[] var3) throws Throwable;

    protected Object[] copyArgs(Object[] objects) throws IOException, ClassNotFoundException {
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = this.copyObj(objects[i]);
        }
        return objects;
    }

    protected Object copyObj(Object object) throws IOException, ClassNotFoundException {
        MarshalledObject<Object> obj = new MarshalledObject<Object>(object);
        return obj.get();
    }

    public void invalidateReference() {
        this.container = null;
        this.deploymentInfo = null;
        this.isInvalidReference = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invalidateAllHandlers(Object key) {
        HashSet set = (HashSet)liveHandleRegistry.remove(key);
        if (set == null) {
            return;
        }
        HashSet hashSet = set;
        synchronized (hashSet) {
            Iterator handlers = set.iterator();
            while (handlers.hasNext()) {
                BaseEjbProxyHandler aHandler = (BaseEjbProxyHandler)handlers.next();
                aHandler.invalidateReference();
            }
        }
    }

    protected abstract Object _writeReplace(Object var1) throws ObjectStreamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerHandler(Object key, BaseEjbProxyHandler handler) {
        HashSet<BaseEjbProxyHandler> set = (HashSet<BaseEjbProxyHandler>)liveHandleRegistry.get(key);
        if (set != null) {
            HashSet<BaseEjbProxyHandler> hashSet = set;
            synchronized (hashSet) {
                set.add(handler);
            }
        } else {
            set = new HashSet<BaseEjbProxyHandler>();
            set.add(handler);
            liveHandleRegistry.put(key, set);
        }
    }

    public abstract ProxyInfo getProxyInfo();

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean isLocal) {
        this.isLocal = isLocal;
        this.doIntraVmCopy = !isLocal;
    }
}

