/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import org.apache.log4j.Category;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.BaseEjbProxyHandler;
import org.openejb.core.ivm.EjbObjectProxyHandler;
import org.openejb.core.ivm.IntraVmArtifact;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.core.ivm.IntraVmHandle;
import org.openejb.core.ivm.IntraVmMetaData;
import org.openejb.core.ivm.IntraVmProxy;
import org.openejb.core.ivm.SpecialProxyInfo;
import org.openejb.util.proxy.InvocationHandler;
import org.openejb.util.proxy.ProxyManager;

public abstract class EjbHomeProxyHandler
extends BaseEjbProxyHandler {
    protected static final Category logger = Category.getInstance((String)"OpenEJB");
    static final HashMap dispatchTable = new HashMap();

    public EjbHomeProxyHandler(RpcContainer container, Object pk, Object depID) {
        super(container, pk, depID);
    }

    public void invalidateReference() {
        throw new IllegalStateException("A home reference must never be invalidated!");
    }

    protected Object createProxy(ProxyInfo proxyInfo) {
        if (proxyInfo instanceof SpecialProxyInfo) {
            Object proxy = ((SpecialProxyInfo)proxyInfo).getProxy();
            if (proxy == null) {
                throw new RuntimeException("Could not create IVM proxy for " + proxyInfo.getInterface() + " interface");
            }
            return proxy;
        }
        Object newProxy = null;
        try {
            EjbObjectProxyHandler handler = this.newEjbObjectHandler(proxyInfo.getBeanContainer(), proxyInfo.getPrimaryKey(), proxyInfo.getDeploymentInfo().getDeploymentID());
            handler.setLocal(this.isLocal());
            handler.doIntraVmCopy = this.doIntraVmCopy;
            Class[] interfaces = new Class[]{proxyInfo.getInterface(), IntraVmProxy.class};
            newProxy = ProxyManager.newProxyInstance(interfaces, (InvocationHandler)handler);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Could not create IVM proxy for " + proxyInfo.getInterface() + " interface");
        }
        if (newProxy == null) {
            throw new RuntimeException("Could not create IVM proxy for " + proxyInfo.getInterface() + " interface");
        }
        return newProxy;
    }

    protected abstract EjbObjectProxyHandler newEjbObjectHandler(RpcContainer var1, Object var2, Object var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object _invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("invoking method " + method.getName() + " on " + this.deploymentID));
        }
        String methodName = method.getName();
        try {
            Object retValue;
            Integer operation = (Integer)dispatchTable.get(methodName);
            if (operation == null) {
                if (!methodName.startsWith("find")) throw new UnsupportedOperationException("Unkown method: " + method);
                retValue = this.findX(method, args, proxy);
            } else {
                switch (operation) {
                    case 1: {
                        retValue = this.create(method, args, proxy);
                        break;
                    }
                    case 2: {
                        retValue = this.getEJBMetaData(method, args, proxy);
                        break;
                    }
                    case 3: {
                        retValue = this.getHomeHandle(method, args, proxy);
                        break;
                    }
                    case 4: {
                        Class<?> type = method.getParameterTypes()[0];
                        if (Handle.class.isAssignableFrom(type)) {
                            retValue = this.removeWithHandle(method, args, proxy);
                            break;
                        }
                        retValue = this.removeByPrimaryKey(method, args, proxy);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Inconsistent internal state: value " + operation + " for operation " + methodName);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("finished invoking method " + method.getName() + ". Return value:" + retValue));
                return retValue;
            } else {
                if (!logger.isInfoEnabled()) return retValue;
                logger.info((Object)("finished invoking method " + method.getName()));
            }
            return retValue;
        }
        catch (InvalidateReferenceException ire) {
            throw ire.getRootCause();
        }
        catch (ApplicationException ae) {
            throw ae.getRootCause();
        }
        catch (SystemException se) {
            throw new RemoteException("Container has suffered a SystemException", se.getRootCause());
        }
        catch (OpenEJBException oe) {
            throw new RemoteException("Unknown Container Exception", oe.getRootCause());
        }
        catch (Throwable t) {
            logger.info((Object)("finished invoking method " + method.getName() + " with exception:" + t), t);
            throw t;
        }
    }

    protected Object create(Method method, Object[] args, Object proxy) throws Throwable {
        ProxyInfo proxyInfo = (ProxyInfo)this.container.invoke(this.deploymentID, method, args, null, this.getThreadSpecificSecurityIdentity());
        return this.createProxy(proxyInfo);
    }

    protected abstract Object findX(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object getEJBMetaData(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        IntraVmMetaData metaData = new IntraVmMetaData(this.deploymentInfo.getHomeInterface(), this.deploymentInfo.getRemoteInterface(), this.deploymentInfo.getPrimaryKeyClass(), this.deploymentInfo.getComponentType());
        metaData.setEJBHome((EJBHome)proxy);
        return metaData;
    }

    protected Object getHomeHandle(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return new IntraVmHandle(proxy);
    }

    public ProxyInfo getProxyInfo() {
        return new ProxyInfo((DeploymentInfo)this.deploymentInfo, null, this.deploymentInfo.getHomeInterface(), this.container);
    }

    protected Object _writeReplace(Object proxy) throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(proxy);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return proxy;
        }
        return OpenEJB.getApplicationServer().getEJBHome(this.getProxyInfo());
    }

    protected Object removeWithHandle(Method method, Object[] args, Object proxy) throws Throwable {
        EjbObjectProxyHandler stub;
        IntraVmHandle handle = (IntraVmHandle)args[0];
        Object primKey = handle.getPrimaryKey();
        try {
            stub = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(handle.getEJBObject());
        }
        catch (IllegalArgumentException e) {
            stub = null;
        }
        this.container.invoke(this.deploymentID, method, args, primKey, ThreadContext.getThreadContext().getSecurityIdentity());
        if (stub != null) {
            EjbHomeProxyHandler.invalidateAllHandlers(stub.getRegistryId());
        }
        return null;
    }

    protected abstract Object removeByPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    static {
        dispatchTable.put("create", new Integer(1));
        dispatchTable.put("getEJBMetaData", new Integer(2));
        dispatchTable.put("getHomeHandle", new Integer(3));
        dispatchTable.put("remove", new Integer(4));
    }
}

