/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.log4j.Category;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.core.ivm.BaseEjbProxyHandler;
import org.openejb.core.ivm.IntraVmArtifact;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.core.ivm.IntraVmHandle;
import org.openejb.core.ivm.SpecialProxyInfo;

public abstract class EjbObjectProxyHandler
extends BaseEjbProxyHandler {
    protected static final Category logger = Category.getInstance((String)"OpenEJB");
    static final HashMap dispatchTable = new HashMap();

    public EjbObjectProxyHandler(RpcContainer container, Object pk, Object depID) {
        super(container, pk, depID);
    }

    public abstract Object getRegistryId();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object _invoke(Object p, Method m, Object[] a) throws Throwable {
        Object object;
        Object retValue = null;
        Throwable exc = null;
        try {
            try {
                Integer operation;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("invoking method " + m.getName() + " on " + this.deploymentID + " with identity " + this.primaryKey));
                }
                if ((operation = (Integer)dispatchTable.get(m.getName())) == null) {
                    retValue = this.businessMethod(m, a, p);
                } else {
                    switch (operation) {
                        case 1: {
                            retValue = this.getHandle(m, a, p);
                            break;
                        }
                        case 2: {
                            retValue = this.getPrimaryKey(m, a, p);
                            break;
                        }
                        case 3: {
                            retValue = this.isIdentical(m, a, p);
                            break;
                        }
                        case 4: {
                            retValue = this.remove(m, a, p);
                            break;
                        }
                        case 5: {
                            retValue = this.getEJBHome(m, a, p);
                            break;
                        }
                        default: {
                            throw new RuntimeException("Inconsistent internal state");
                        }
                    }
                }
                if (retValue instanceof SpecialProxyInfo) {
                    retValue = ((SpecialProxyInfo)retValue).getProxy();
                }
                object = retValue;
                Object var9_12 = null;
            }
            catch (InvalidateReferenceException ire) {
                EjbObjectProxyHandler.invalidateAllHandlers(this.getRegistryId());
                exc = ire.getRootCause() != null ? ire.getRootCause() : ire;
                throw exc;
            }
            catch (ApplicationException ae) {
                exc = ae.getRootCause() != null ? ae.getRootCause() : ae;
                throw exc;
            }
            catch (SystemException se) {
                this.invalidateReference();
                exc = se.getRootCause() != null ? se.getRootCause() : se;
                logger.error((Object)"The container received an unexpected exception: ", exc);
                throw new RemoteException("Container has suffered a SystemException", exc);
            }
            catch (OpenEJBException oe) {
                exc = oe.getRootCause() != null ? oe.getRootCause() : oe;
                logger.warn((Object)"The container received an unexpected exception: ", exc);
                throw new RemoteException("Unknown Container Exception", oe.getRootCause());
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (logger.isDebugEnabled()) {
                if (exc == null) {
                    logger.debug((Object)("finished invoking method " + m.getName() + ". Return value:" + retValue));
                    throw throwable;
                }
                logger.debug((Object)("finished invoking method " + m.getName() + " with exception " + exc));
                throw throwable;
            }
            if (!logger.isInfoEnabled()) throw throwable;
            if (exc == null) {
                logger.debug((Object)("finished invoking method " + m.getName()));
                throw throwable;
            }
            logger.debug((Object)("finished invoking method " + m.getName() + " with exception " + exc));
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            if (exc == null) {
                logger.debug((Object)("finished invoking method " + m.getName() + ". Return value:" + retValue));
                return object;
            }
            logger.debug((Object)("finished invoking method " + m.getName() + " with exception " + exc));
            return object;
        }
        if (!logger.isInfoEnabled()) return object;
        if (exc == null) {
            logger.debug((Object)("finished invoking method " + m.getName()));
            return object;
        }
        logger.debug((Object)("finished invoking method " + m.getName() + " with exception " + exc));
        return object;
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.deploymentInfo.getEJBHome();
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return new IntraVmHandle(proxy);
    }

    public ProxyInfo getProxyInfo() {
        return new ProxyInfo((DeploymentInfo)this.deploymentInfo, this.primaryKey, this.isLocal(), this.container);
    }

    protected Object _writeReplace(Object proxy) throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(proxy);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return proxy;
        }
        return OpenEJB.getApplicationServer().getEJBObject(this.getProxyInfo());
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object businessMethod(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.container.invoke(this.deploymentID, method, args, this.primaryKey, this.getThreadSpecificSecurityIdentity());
    }

    static {
        dispatchTable.put("getHandle", new Integer(1));
        dispatchTable.put("getPrimaryKey", new Integer(2));
        dispatchTable.put("isIdentical", new Integer(3));
        dispatchTable.put("remove", new Integer(4));
        dispatchTable.put("getEJBHome", new Integer(5));
    }
}

