/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import org.openejb.util.FastThreadLocal;

public class IntraVmCopyMonitor {
    private static FastThreadLocal threadStorage = new FastThreadLocal();
    boolean intraVmCopyOperation = false;
    boolean statefulPassivationOperation = false;

    IntraVmCopyMonitor() {
    }

    public static boolean exists() {
        return threadStorage.get() != null;
    }

    public static void release() {
        threadStorage.set(null);
    }

    static IntraVmCopyMonitor getMonitor() {
        IntraVmCopyMonitor monitor = (IntraVmCopyMonitor)threadStorage.get();
        if (monitor == null) {
            monitor = new IntraVmCopyMonitor();
            threadStorage.set(monitor);
        }
        return monitor;
    }

    public static void preCopyOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        monitor.intraVmCopyOperation = true;
    }

    public static void postCopyOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        monitor.intraVmCopyOperation = false;
    }

    public static void prePassivationOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        monitor.statefulPassivationOperation = true;
    }

    public static void postPassivationOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        monitor.statefulPassivationOperation = false;
    }

    public static boolean isIntraVmCopyOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        return monitor.intraVmCopyOperation;
    }

    public static boolean isStatefulPassivationOperation() {
        IntraVmCopyMonitor monitor = IntraVmCopyMonitor.getMonitor();
        return monitor.statefulPassivationOperation;
    }
}

