/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import org.openejb.OpenEJB;
import org.openejb.core.ivm.BaseEjbProxyHandler;
import org.openejb.core.ivm.IntraVmArtifact;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.util.proxy.ProxyManager;

public class IntraVmMetaData
implements EJBMetaData,
Serializable {
    public static final byte ENTITY = 8;
    public static final byte STATEFUL = 6;
    public static final byte STATELESS = 7;
    protected Class homeClass;
    protected Class remoteClass;
    protected Class keyClass;
    protected EJBHome homeStub;
    protected byte type;

    public IntraVmMetaData(Class homeInterface, Class remoteInterface, byte typeOfBean) {
        this(homeInterface, remoteInterface, null, typeOfBean);
    }

    public IntraVmMetaData(Class homeInterface, Class remoteInterface, Class primaryKeyClass, byte typeOfBean) {
        if (typeOfBean != 8 && typeOfBean != 6 && typeOfBean != 7) {
            if (typeOfBean == 9) {
                typeOfBean = (byte)8;
            } else {
                throw new IllegalArgumentException("typeOfBean parameter not in range: " + typeOfBean);
            }
        }
        if (homeInterface == null || remoteInterface == null) {
            throw new IllegalArgumentException();
        }
        if (typeOfBean == 8 && primaryKeyClass == null) {
            throw new IllegalArgumentException();
        }
        this.type = typeOfBean;
        this.homeClass = homeInterface;
        this.remoteClass = remoteInterface;
        this.keyClass = primaryKeyClass;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public Class getPrimaryKeyClass() {
        if (this.type == 8) {
            return this.keyClass;
        }
        throw new UnsupportedOperationException("Session objects are private resources and do not have primary keys");
    }

    public boolean isSession() {
        return this.type == 6 || this.type == 7;
    }

    public boolean isStatelessSession() {
        return this.type == 7;
    }

    public void setEJBHome(EJBHome home) {
        this.homeStub = home;
    }

    public EJBHome getEJBHome() {
        return this.homeStub;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(this);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return this;
        }
        BaseEjbProxyHandler handler = (BaseEjbProxyHandler)ProxyManager.getInvocationHandler(this.homeStub);
        return OpenEJB.getApplicationServer().getEJBMetaData(handler.getProxyInfo());
    }
}

