/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm;

import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.openejb.DeploymentInfo;
import org.openejb.ProxyInfo;
import org.openejb.core.entity.EntityEjbHomeHandler;
import org.openejb.core.ivm.EjbHomeProxyHandler;
import org.openejb.core.ivm.IntraVmHandle;
import org.openejb.core.ivm.IntraVmMetaData;
import org.openejb.core.ivm.IntraVmProxy;
import org.openejb.core.stateful.StatefulEjbHomeHandler;
import org.openejb.core.stateless.StatelessEjbHomeHandler;
import org.openejb.spi.ApplicationServer;
import org.openejb.util.proxy.InvocationHandler;
import org.openejb.util.proxy.ProxyManager;

public class IntraVmServer
implements ApplicationServer {
    public EJBMetaData getEJBMetaData(ProxyInfo pi) {
        DeploymentInfo di = pi.getDeploymentInfo();
        IntraVmMetaData metaData = new IntraVmMetaData(di.getHomeInterface(), di.getRemoteInterface(), di.getComponentType());
        metaData.setEJBHome(this.getEJBHome(pi));
        return metaData;
    }

    public Handle getHandle(ProxyInfo pi) {
        return new IntraVmHandle(this.getEJBObject(pi));
    }

    public HomeHandle getHomeHandle(ProxyInfo pi) {
        return new IntraVmHandle(this.getEJBHome(pi));
    }

    public EJBObject getEJBObject(ProxyInfo pi) {
        Object handler = null;
        return (EJBObject)this.getEjbHomeHandler(pi).createProxy(pi);
    }

    public EJBHome getEJBHome(ProxyInfo pi) {
        if (pi.getDeploymentInfo() instanceof org.openejb.core.DeploymentInfo) {
            org.openejb.core.DeploymentInfo coreDeployment = (org.openejb.core.DeploymentInfo)pi.getDeploymentInfo();
            return coreDeployment.getEJBHome();
        }
        try {
            Class[] interfaces = new Class[]{pi.getDeploymentInfo().getHomeInterface(), IntraVmProxy.class};
            return (EJBHome)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)this.getEjbHomeHandler(pi));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create EJBHome stub" + e.getMessage());
        }
    }

    private EjbHomeProxyHandler getEjbHomeHandler(ProxyInfo pi) {
        switch (pi.getDeploymentInfo().getComponentType()) {
            case 8: 
            case 9: {
                return new EntityEjbHomeHandler(pi.getBeanContainer(), pi.getPrimaryKey(), pi.getDeploymentInfo().getDeploymentID());
            }
            case 6: {
                return new StatefulEjbHomeHandler(pi.getBeanContainer(), pi.getPrimaryKey(), pi.getDeploymentInfo().getDeploymentID());
            }
            case 7: {
                return new StatelessEjbHomeHandler(pi.getBeanContainer(), pi.getPrimaryKey(), pi.getDeploymentInfo().getDeploymentID());
            }
        }
        throw new RuntimeException("Unknown EJB type: " + pi.getDeploymentInfo());
    }
}

