/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm.naming;

import com.sun.naming.internal.ResourceManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ObjectFactory;
import org.openejb.core.CoreUserTransaction;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.core.ivm.naming.JndiEncArtifact;
import org.openejb.core.ivm.naming.NameNode;
import org.openejb.core.ivm.naming.ParsedName;
import org.openejb.core.ivm.naming.Reference;
import org.openejb.util.ClasspathUtils;

public class IvmContext
implements Context,
Serializable {
    Hashtable myEnv;
    boolean readOnly = false;
    HashMap fastCache = new HashMap();
    public NameNode mynode;
    static ObjectFactory[] federatedFactories = null;

    public static IvmContext createRootContext() {
        return new IvmContext(new NameNode(null, new ParsedName("/"), null));
    }

    public IvmContext() {
        this(new NameNode(null, new ParsedName("root"), null));
    }

    public IvmContext(NameNode node) {
        this.mynode = node;
    }

    public IvmContext(Hashtable environment) throws NamingException {
        this();
        if (environment == null) {
            throw new NamingException("Invalid Argument");
        }
        this.myEnv = (Hashtable)environment.clone();
    }

    public Object lookup(String compositName) throws NamingException {
        if (compositName.equals("")) {
            return this;
        }
        if (compositName.equals("java:comp/UserTransaction") && ThreadContext.getThreadContext().getDeploymentInfo() == null) {
            return new CoreUserTransaction();
        }
        String compoundName = null;
        int indx = compositName.indexOf(":");
        compoundName = indx > -1 ? compositName.substring(indx + 1) : this.mynode.atomicName + '/' + compositName;
        Object obj = this.fastCache.get(compoundName);
        if (obj == null) {
            try {
                obj = this.mynode.resolve(new ParsedName(compoundName));
            }
            catch (NameNotFoundException nnfe) {
                obj = this.federate(compositName);
            }
            this.fastCache.put(compoundName, obj);
        }
        if (obj.getClass() == IvmContext.class) {
            ((IvmContext)obj).myEnv = this.myEnv;
        } else if (obj instanceof Reference) {
            obj = ((Reference)obj).getObject();
        }
        return obj;
    }

    protected Object federate(String compositName) throws NamingException {
        ObjectFactory[] factories = IvmContext.getFederatedFactories();
        for (int i = 0; i < factories.length; ++i) {
            try {
                CompositeName name = new CompositeName(compositName);
                Object obj = factories[i].getObjectInstance(null, name, null, null);
                if (obj instanceof Context) {
                    return ((Context)obj).lookup(compositName);
                }
                if (obj == null) continue;
                return obj;
            }
            catch (Exception nnfe) {
                // empty catch block
            }
        }
        throw new NameNotFoundException("Name \"" + compositName + "\" not found.");
    }

    public static ObjectFactory[] getFederatedFactories() throws NamingException {
        if (federatedFactories == null) {
            HashSet<ObjectFactory> factories = new HashSet<ObjectFactory>();
            Hashtable<?, ?> jndiProps = ResourceManager.getInitialEnvironment(null);
            String pkgs = (String)jndiProps.get("java.naming.factory.url.pkgs");
            if (pkgs == null) {
                return new ObjectFactory[0];
            }
            StringTokenizer parser = new StringTokenizer(pkgs, ":");
            while (parser.hasMoreTokens()) {
                String className = parser.nextToken() + ".java.javaURLContextFactory";
                if (className.equals("org.openejb.core.ivm.naming.java.javaURLContextFactory")) continue;
                try {
                    ClassLoader cl = ClasspathUtils.getContextClassLoader();
                    Class<?> factoryClass = Class.forName(className, true, cl);
                    ObjectFactory factoryInstance = (ObjectFactory)factoryClass.newInstance();
                    factories.add(factoryInstance);
                }
                catch (ClassNotFoundException cnfe) {
                }
                catch (Throwable e) {
                    NamingException ne = new NamingException("Federation failed: Cannot instantiate " + className);
                    ne.setRootCause(e);
                    throw ne;
                }
            }
            Object[] temp = factories.toArray();
            federatedFactories = new ObjectFactory[temp.length];
            System.arraycopy(temp, 0, federatedFactories, 0, federatedFactories.length);
        }
        return federatedFactories;
    }

    public Object lookup(Name compositName) throws NamingException {
        return this.lookup(compositName.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        this.checkReadOnly();
        int indx = name.indexOf(":");
        if (indx > -1) {
            name = name.substring(indx + 1);
        }
        if (this.fastCache.containsKey(name)) {
            throw new NameAlreadyBoundException();
        }
        this.mynode.bind(new ParsedName(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj.getClass() == IvmContext.class) {
            return new MyListEnumeration(((IvmContext)obj).mynode);
        }
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Object obj = this.lookup(name);
        if (obj.getClass() == IvmContext.class) {
            return new MyListEnumeration(((IvmContext)obj).mynode);
        }
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        this.checkReadOnly();
        int indx = name.indexOf(":");
        if (indx > -1) {
            name = name.substring(indx + 1);
        }
        if (this.fastCache.containsKey(name)) {
            throw new NameAlreadyBoundException();
        }
        return this.mynode.createSubcontext(new ParsedName(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(5, 0.75f);
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable(3, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public void close() throws NamingException {
    }

    protected void checkReadOnly() throws OperationNotSupportedException {
        if (this.readOnly) {
            throw new OperationNotSupportedException();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return new JndiEncArtifact(this);
        }
        throw new NotSerializableException("IntraVM java.naming.Context objects can not be passed as arguments");
    }

    public static void main(String[] str) throws Exception {
        String str1 = "root/comp/env/rate/work/doc/lot/pop";
        String str2 = "root/comp/env/rate/work/doc/lot/price";
        String str3 = "root/comp/env/rate/work/doc/lot";
        String str4 = "root/comp/env/rate/work/doc/lot/break/story";
        IvmContext context = new IvmContext();
        context.bind(str1, (Object)new Integer(1));
        context.bind(str2, (Object)new Integer(2));
        context.bind(str4, (Object)new Integer(3));
        Context subcntx = (Context)context.lookup(str3);
        Object x = null;
        FileOutputStream fos = new FileOutputStream("x.ser");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        IntraVmCopyMonitor.prePassivationOperation();
        oos.writeObject(subcntx);
        IntraVmCopyMonitor.postPassivationOperation();
        oos.flush();
        oos.close();
        FileInputStream fis = new FileInputStream("x.ser");
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object newObj = ois.readObject();
        ois.close();
    }

    protected abstract class MyNamingEnumeration
    implements NamingEnumeration {
        Enumeration myEnum;

        public MyNamingEnumeration(NameNode parentNode) {
            Vector<NameNode> vect = new Vector<NameNode>();
            NameNode node = parentNode.subTree;
            if (node == null) {
                node = parentNode;
            } else {
                vect.addElement(node);
            }
            this.gatherNodes(node, vect);
            this.buildEnumeration(vect);
        }

        protected abstract void buildEnumeration(Vector var1);

        protected void gatherNodes(NameNode node, Vector vect) {
            if (node.lessTree != null) {
                vect.addElement(node.lessTree);
                this.gatherNodes(node.lessTree, vect);
            }
            if (node.grtrTree != null) {
                vect.addElement(node.grtrTree);
                this.gatherNodes(node.grtrTree, vect);
            }
        }

        public void close() {
            this.myEnum = null;
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        public boolean hasMoreElements() {
            return this.myEnum.hasMoreElements();
        }

        public Object nextElement() {
            return this.myEnum.nextElement();
        }
    }

    protected class MyListEnumeration
    extends MyNamingEnumeration {
        public MyListEnumeration(NameNode parentNode) {
            super(parentNode);
        }

        protected void buildEnumeration(Vector vect) {
            for (int i = 0; i < vect.size(); ++i) {
                NameNode node = (NameNode)vect.elementAt(i);
                String className = node.getBinding().getClass().getName();
                vect.setElementAt(new NameClassPair(node.atomicName, className), i);
            }
            this.myEnum = vect.elements();
        }
    }

    protected class MyBindingEnumeration
    extends MyNamingEnumeration {
        public MyBindingEnumeration(NameNode parentNode) {
            super(parentNode);
        }

        protected void buildEnumeration(Vector vect) {
            for (int i = 0; i < vect.size(); ++i) {
                NameNode node = (NameNode)vect.elementAt(i);
                String className = node.getBinding().getClass().getName();
                vect.setElementAt(new Binding(node.atomicName, className, node.getBinding()), i);
            }
            this.myEnum = vect.elements();
        }
    }
}

