/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm.naming;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.openejb.core.DeploymentInfo;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.naming.IvmContext;
import org.openejb.core.ivm.naming.NameNode;

public class JndiEncArtifact
implements Serializable {
    String path = new String();

    public JndiEncArtifact(IvmContext context) {
        NameNode node = context.mynode;
        do {
            this.path = node.atomicName + "/" + this.path;
        } while ((node = node.parent) != null);
    }

    public Object readResolve() throws ObjectStreamException {
        ThreadContext thrdCntx = ThreadContext.getThreadContext();
        DeploymentInfo deployment = thrdCntx.getDeploymentInfo();
        Context cntx = deployment.getJndiEnc();
        try {
            Object obj = cntx.lookup(this.path);
            if (obj == null) {
                throw new InvalidObjectException("JNDI ENC context reference could not be properly resolved when bean instance was activated");
            }
            return obj;
        }
        catch (NamingException e) {
            throw new InvalidObjectException("JNDI ENC context reference could not be properly resolved due to a JNDI exception, when bean instance was activated");
        }
    }
}

