/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.ivm.naming;

import java.io.Serializable;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import org.openejb.core.ivm.naming.IvmContext;
import org.openejb.core.ivm.naming.ParsedName;

public class NameNode
implements Serializable {
    public String atomicName;
    public int atomicHash;
    public NameNode lessTree;
    public NameNode grtrTree;
    public NameNode subTree;
    public NameNode parent;
    public Object myObject;
    public transient IvmContext myContext;

    public NameNode(NameNode parent, ParsedName name, Object obj) {
        this.atomicName = name.getComponent();
        this.atomicHash = name.getComponentHashCode();
        this.parent = parent;
        if (name.next()) {
            this.subTree = new NameNode(this, name, obj);
        } else {
            this.myObject = obj;
        }
    }

    public Object getBinding() {
        if (this.myObject != null) {
            return this.myObject;
        }
        if (this.myContext == null) {
            this.myContext = new IvmContext(this);
        }
        return this.myContext;
    }

    public Object resolve(ParsedName name) throws NameNotFoundException {
        int compareResult = name.compareTo(this.atomicHash);
        if (compareResult == 0 && name.getComponent().equals(this.atomicName)) {
            if (name.next()) {
                if (this.subTree == null) {
                    throw new NameNotFoundException("Can not resolve " + name);
                }
                return this.subTree.resolve(name);
            }
            return this.getBinding();
        }
        if (compareResult == -1) {
            if (this.lessTree == null) {
                throw new NameNotFoundException("Can not resolve " + name);
            }
            return this.lessTree.resolve(name);
        }
        if (this.grtrTree == null) {
            throw new NameNotFoundException("Can not resolve " + name);
        }
        return this.grtrTree.resolve(name);
    }

    public void bind(ParsedName name, Object obj) throws NameAlreadyBoundException {
        int compareResult = name.compareTo(this.atomicHash);
        if (compareResult == 0 && name.getComponent().equals(this.atomicName)) {
            if (name.next()) {
                if (this.myObject != null) {
                    throw new NameAlreadyBoundException();
                }
                if (this.subTree == null) {
                    this.subTree = new NameNode(this, name, obj);
                } else {
                    this.subTree.bind(name, obj);
                }
            } else {
                if (this.subTree != null) {
                    throw new NameAlreadyBoundException();
                }
                this.myObject = obj;
            }
        } else if (compareResult == -1) {
            if (this.lessTree == null) {
                this.lessTree = new NameNode(this.parent, name, obj);
            } else {
                this.lessTree.bind(name, obj);
            }
        } else if (this.grtrTree == null) {
            this.grtrTree = new NameNode(this.parent, name, obj);
        } else {
            this.grtrTree.bind(name, obj);
        }
    }

    public IvmContext createSubcontext(ParsedName name) throws NameAlreadyBoundException {
        try {
            this.bind(name, null);
            name.reset();
            return (IvmContext)this.resolve(name);
        }
        catch (NameNotFoundException exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }
}

