/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.io.Serializable;
import javax.ejb.SessionBean;
import javax.transaction.Transaction;

public class BeanEntry
implements Serializable {
    protected final SessionBean bean;
    protected Object primaryKey;
    protected Object ancillaryState;
    protected transient Transaction transaction;
    protected long timeStamp;
    protected long timeOutInterval;
    protected boolean inQue = false;

    protected BeanEntry(SessionBean beanInstance, Object primKey, Object ancillary, long timeOut) {
        this.bean = beanInstance;
        this.primaryKey = primKey;
        this.ancillaryState = ancillary;
        this.transaction = null;
        this.timeStamp = System.currentTimeMillis();
        this.timeOutInterval = timeOut;
    }

    protected boolean isTimedOut() {
        if (this.timeOutInterval == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now - this.timeStamp > this.timeOutInterval;
    }

    protected void resetTimeOut() {
        if (this.timeOutInterval > 0L) {
            this.timeStamp = System.currentTimeMillis();
        }
    }
}

