/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.openejb.SystemException;
import org.openejb.core.stateful.PassivationStrategy;
import org.openejb.spi.Serializer;

public class RAFPassivater
implements PassivationStrategy {
    int fileID = 0;
    Hashtable masterTable = new Hashtable();

    public void init(Properties props) throws SystemException {
    }

    public synchronized void passivate(Hashtable stateTable) throws SystemException {
        try {
            ++this.fileID;
            RandomAccessFile ras = new RandomAccessFile("passivation" + this.fileID + ".ser", "rw");
            Enumeration enumeration = stateTable.keys();
            Pointer lastPointer = null;
            while (enumeration.hasMoreElements()) {
                Object id = enumeration.nextElement();
                Object obj = stateTable.get(id);
                byte[] bytes = Serializer.serialize(obj);
                long filepointer = ras.getFilePointer();
                lastPointer = lastPointer == null ? new Pointer(this.fileID, filepointer, (int)filepointer) : new Pointer(this.fileID, filepointer, (int)(filepointer - lastPointer.filepointer));
                this.masterTable.put(id, lastPointer);
                ras.write(bytes);
            }
            ras.close();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public synchronized Object activate(Object primaryKey) throws SystemException {
        Pointer pointer = (Pointer)this.masterTable.get(primaryKey);
        if (pointer == null) {
            return null;
        }
        try {
            RandomAccessFile ras = new RandomAccessFile("passivation" + pointer.fileid + ".ser", "r");
            byte[] bytes = new byte[pointer.bytesize];
            ras.seek(pointer.filepointer);
            ras.readFully(bytes);
            ras.close();
            return Serializer.deserialize(bytes);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    static class Pointer {
        int fileid;
        long filepointer;
        int bytesize;

        public Pointer(int file, long pointer, int bytecount) {
            this.fileid = file;
            this.filepointer = pointer;
            this.bytesize = bytecount;
        }
    }
}

