/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.util.HashMap;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.stateful.StatefulContainer;
import org.openejb.core.stateful.StatefulInstanceManager;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.util.Logger;

public class SessionSynchronizationCoordinator
implements Synchronization {
    private static HashMap coordinators = new HashMap();
    public static Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");
    private HashMap sessionSynchronizations = new HashMap();

    public static void registerSessionSynchronization(SessionSynchronization session, TransactionContext context) throws javax.transaction.SystemException, RollbackException {
        SessionSynchronizationCoordinator coordinator = null;
        coordinator = (SessionSynchronizationCoordinator)coordinators.get(context.currentTx);
        if (coordinator == null) {
            coordinator = new SessionSynchronizationCoordinator();
            try {
                context.currentTx.registerSynchronization((Synchronization)coordinator);
            }
            catch (Exception e) {
                logger.error("", e);
                return;
            }
            coordinators.put(context.currentTx, coordinator);
        }
        coordinator._registerSessionSynchronization(session, context.callContext);
    }

    private void _registerSessionSynchronization(SessionSynchronization session, ThreadContext callContext) {
        boolean registered = this.sessionSynchronizations.containsKey(callContext.getPrimaryKey());
        if (registered) {
            return;
        }
        try {
            callContext = (ThreadContext)callContext.clone();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.sessionSynchronizations.put(callContext.getPrimaryKey(), callContext);
        byte currentOperation = callContext.getCurrentOperation();
        callContext.setCurrentOperation((byte)2);
        try {
            session.afterBegin();
        }
        catch (Exception e) {
            String message = "An unexpected system exception occured while invoking the afterBegin method on the SessionSynchronization object: " + e.getClass().getName() + " " + e.getMessage();
            logger.error(message, e);
            throw new RuntimeException(message);
        }
        finally {
            callContext.setCurrentOperation(currentOperation);
        }
    }

    public void beforeCompletion() {
        ThreadContext originalContext = ThreadContext.getThreadContext();
        Object[] contexts = this.sessionSynchronizations.values().toArray();
        for (int i = 0; i < contexts.length; ++i) {
            ThreadContext callContext = (ThreadContext)contexts[i];
            ThreadContext.setThreadContext(callContext);
            StatefulInstanceManager instanceManager = null;
            try {
                StatefulContainer container = (StatefulContainer)callContext.getDeploymentInfo().getContainer();
                instanceManager = container.getInstanceManager();
                callContext.setCurrentOperation((byte)4);
                SessionSynchronization bean = (SessionSynchronization)instanceManager.obtainInstance(callContext.getPrimaryKey(), callContext);
                bean.beforeCompletion();
                instanceManager.poolInstance(callContext.getPrimaryKey(), (EnterpriseBean)bean);
                continue;
            }
            catch (InvalidateReferenceException inv) {
                continue;
            }
            catch (Exception e) {
                String message = "An unexpected system exception occured while invoking the beforeCompletion method on the SessionSynchronization object: " + e.getClass().getName() + " " + e.getMessage();
                logger.error(message, e);
                Transaction tx = null;
                try {
                    tx = this.getTxMngr().getTransaction();
                }
                catch (Throwable t) {
                    logger.error("Could not retreive the current transaction from the transaction manager while handling a callback exception from the beforeCompletion method of bean " + callContext.getPrimaryKey());
                }
                try {
                    this.markTxRollbackOnly(tx);
                }
                catch (Throwable t) {
                    logger.error("Could not mark the current transaction for rollback while handling a callback exception from the beforeCompletion method of bean " + callContext.getPrimaryKey());
                }
                this.discardInstance(instanceManager, callContext);
                throw new RuntimeException(message);
            }
            finally {
                ThreadContext.setThreadContext(originalContext);
            }
        }
    }

    public void afterCompletion(int status) {
        ThreadContext originalContext = ThreadContext.getThreadContext();
        Object[] contexts = this.sessionSynchronizations.values().toArray();
        try {
            Transaction tx = this.getTxMngr().getTransaction();
            coordinators.remove(tx);
        }
        catch (Exception e) {
            logger.error("", e);
        }
        for (int i = 0; i < contexts.length; ++i) {
            ThreadContext callContext = (ThreadContext)contexts[i];
            ThreadContext.setThreadContext(callContext);
            StatefulInstanceManager instanceManager = null;
            try {
                StatefulContainer container = (StatefulContainer)callContext.getDeploymentInfo().getContainer();
                instanceManager = container.getInstanceManager();
                callContext.setCurrentOperation((byte)3);
                SessionSynchronization bean = (SessionSynchronization)instanceManager.obtainInstance(callContext.getPrimaryKey(), callContext);
                bean.afterCompletion(status == 3);
                instanceManager.poolInstance(callContext.getPrimaryKey(), (EnterpriseBean)bean);
                continue;
            }
            catch (InvalidateReferenceException inv) {
                continue;
            }
            catch (Exception e) {
                String message = "An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object: " + e.getClass().getName() + " " + e.getMessage();
                logger.error(message, e);
                Transaction tx = null;
                try {
                    tx = this.getTxMngr().getTransaction();
                }
                catch (Throwable t) {
                    logger.error("Could not retreive the current transaction from the transaction manager while handling a callback exception from the afterCompletion method of bean " + callContext.getPrimaryKey());
                }
                try {
                    this.markTxRollbackOnly(tx);
                }
                catch (Throwable t) {
                    logger.error("Could not mark the current transaction for rollback while handling a callback exception from the afterCompletion method of bean " + callContext.getPrimaryKey());
                }
                this.discardInstance(instanceManager, callContext);
                throw new RuntimeException(message);
            }
            finally {
                ThreadContext.setThreadContext(originalContext);
            }
        }
    }

    protected void discardInstance(StatefulInstanceManager instanceManager, ThreadContext callContext) {
        try {
            instanceManager.freeInstance(callContext.getPrimaryKey());
        }
        catch (OpenEJBException openEJBException) {
            // empty catch block
        }
    }

    protected void markTxRollbackOnly(Transaction tx) throws SystemException {
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (javax.transaction.SystemException se) {
            throw new SystemException(se);
        }
    }

    protected TransactionManager getTxMngr() {
        return OpenEJB.getTransactionManager();
    }

    protected void throwExceptionToServer(Throwable sysException) throws ApplicationException {
        throw new ApplicationException(sysException);
    }
}

