/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import javax.ejb.EnterpriseBean;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import org.openejb.ApplicationException;
import org.openejb.Container;
import org.openejb.InvalidateReferenceException;
import org.openejb.SystemException;
import org.openejb.core.stateful.SessionSynchronizationCoordinator;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;

public class SessionSynchronizationTxPolicy
extends TransactionPolicy {
    protected TransactionPolicy policy;

    public SessionSynchronizationTxPolicy(TransactionPolicy policy) {
        this.policy = policy;
        this.container = policy.getContainer();
        this.policyType = policy.policyType;
        if (this.container instanceof Container && ((Container)((Object)this.container)).getContainerType() != 2 || this.policyType == 1 || this.policyType == 2) {
            throw new IllegalArgumentException();
        }
    }

    public void beforeInvoke(EnterpriseBean instance, TransactionContext context) throws SystemException, ApplicationException {
        this.policy.beforeInvoke(instance, context);
        if (context.currentTx == null) {
            return;
        }
        try {
            SessionSynchronization session = (SessionSynchronization)instance;
            SessionSynchronizationCoordinator.registerSessionSynchronization(session, context);
        }
        catch (RollbackException e) {
            logger.error("Cannot register the SessionSynchronization bean with the transaction, the transaction has been rolled back");
            this.handleSystemException(e, instance, context);
        }
        catch (javax.transaction.SystemException e) {
            logger.error("Cannot register the SessionSynchronization bean with the transaction, received an unknown system exception from the transaction manager: " + e.getMessage());
            this.handleSystemException(e, instance, context);
        }
        catch (Throwable e) {
            logger.error("Cannot register the SessionSynchronization bean with the transaction, received an unknown exception: " + e.getClass().getName() + " " + e.getMessage());
            this.handleSystemException(e, instance, context);
        }
    }

    public void afterInvoke(EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        this.policy.afterInvoke(instance, context);
    }

    public void handleApplicationException(Throwable appException, TransactionContext context) throws ApplicationException {
        this.policy.handleApplicationException(appException, context);
    }

    public void handleSystemException(Throwable sysException, EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        try {
            this.policy.handleSystemException(sysException, instance, context);
        }
        catch (ApplicationException e) {
            throw new InvalidateReferenceException(e.getRootCause());
        }
    }
}

