/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.log4j.Category;
import org.openejb.SystemException;
import org.openejb.core.stateful.BeanEntry;
import org.openejb.core.stateful.PassivationStrategy;
import org.openejb.util.FileUtils;

public class SimplePassivater
implements PassivationStrategy {
    private File sessionDirectory;
    protected static final Category logger = Category.getInstance((String)"OpenEJB");

    public void init(Properties props) throws SystemException {
        if (props != null) {
            props = new Properties();
        }
        String dir = props.getProperty("org/openejb/core/InstanceManager/PASSIVATOR_PATH_PREFIX");
        try {
            this.sessionDirectory = dir != null ? FileUtils.getBase().getDirectory(dir) : new File("java.io.tmpdir");
            logger.info((Object)("Using directory " + this.sessionDirectory + " for stateful session passivation"));
        }
        catch (IOException e) {
            throw new SystemException(this.getClass().getName() + ".init(): can't use directory prefix " + dir + ":" + e);
        }
    }

    public void passivate(Object primaryKey, Object state) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            logger.info((Object)("Passivating to file " + sessionFile));
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(sessionFile));
            oos.writeObject(state);
            oos.close();
            sessionFile.deleteOnExit();
        }
        catch (NotSerializableException nse) {
            logger.info((Object)"Passivation failed ", (Throwable)nse);
            throw new SystemException("The type " + nse.getMessage() + " in the bean class " + ((BeanEntry)state).bean.getClass().getName() + " is not serializable as mandated by the EJB specification.");
        }
        catch (Exception t) {
            logger.info((Object)"Passivation failed ", (Throwable)t);
            throw new SystemException(t);
        }
    }

    public void passivate(Hashtable hash) throws SystemException {
        Enumeration enumeration = hash.keys();
        while (enumeration.hasMoreElements()) {
            Object id = enumeration.nextElement();
            this.passivate(id, hash.get(id));
        }
    }

    public Object activate(Object primaryKey) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (sessionFile.exists()) {
                logger.info((Object)("Activating from file " + sessionFile));
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(sessionFile));
                Object state = ois.readObject();
                ois.close();
                sessionFile.delete();
                return state;
            }
            logger.info((Object)("Activation failed: file not found " + sessionFile));
            return null;
        }
        catch (Exception t) {
            logger.info((Object)"Activation failed ", (Throwable)t);
            throw new SystemException(t);
        }
    }
}

