/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.rmi.RemoteException;
import javax.ejb.EnterpriseBean;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import org.openejb.ApplicationException;
import org.openejb.Container;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.core.stateful.StatefulContainer;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;

public class StatefulBeanManagedTxPolicy
extends TransactionPolicy {
    protected StatefulContainer statefulContainer;

    public StatefulBeanManagedTxPolicy(TransactionContainer container) {
        this();
        if (container instanceof Container && ((Container)((Object)container)).getContainerType() != 2) {
            throw new IllegalArgumentException();
        }
        this.container = container;
        this.statefulContainer = (StatefulContainer)container;
    }

    public StatefulBeanManagedTxPolicy() {
        this.policyType = 6;
    }

    public String policyToString() {
        return "TX_BeanManaged: ";
    }

    public void beforeInvoke(EnterpriseBean instance, TransactionContext context) throws SystemException, ApplicationException {
        try {
            context.clientTx = this.suspendTransaction();
            Object primaryKey = context.callContext.getPrimaryKey();
            Object possibleBeanTx = this.statefulContainer.getInstanceManager().getAncillaryState(primaryKey);
            if (possibleBeanTx instanceof Transaction) {
                context.currentTx = (Transaction)possibleBeanTx;
                this.resumeTransaction(context.currentTx);
            }
        }
        catch (OpenEJBException e) {
            this.handleSystemException(e.getRootCause(), instance, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInvoke(EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        try {
            context.currentTx = this.getTxMngr().getTransaction();
            if (context.currentTx != null && context.currentTx.getStatus() != 3 && context.currentTx.getStatus() != 4) {
                this.suspendTransaction();
            }
            Object primaryKey = context.callContext.getPrimaryKey();
            this.statefulContainer.getInstanceManager().setAncillaryState(primaryKey, context.currentTx);
        }
        catch (OpenEJBException e) {
            this.handleSystemException(e.getRootCause(), instance, context);
        }
        catch (javax.transaction.SystemException e) {
            this.handleSystemException(e, instance, context);
        }
        catch (Throwable e) {
            this.handleSystemException(e, instance, context);
        }
        finally {
            this.resumeTransaction(context.clientTx);
        }
    }

    public void handleApplicationException(Throwable appException, TransactionContext context) throws ApplicationException {
        throw new ApplicationException(appException);
    }

    public void handleSystemException(Throwable sysException, EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        this.logSystemException(sysException);
        if (context.currentTx != null) {
            this.markTxRollbackOnly(context.currentTx);
        }
        this.discardBeanInstance(instance, context.callContext);
        this.throwExceptionToServer(sysException);
    }

    protected void throwExceptionToServer(Throwable sysException) throws ApplicationException {
        RemoteException re = new RemoteException("The bean encountered a non-application exception.", sysException);
        throw new InvalidateReferenceException(re);
    }

    protected void throwTxExceptionToServer(Throwable sysException) throws ApplicationException {
        String message = "The transaction was rolled back because the bean encountered a non-application exception :" + sysException.getClass().getName() + " : " + sysException.getMessage();
        TransactionRolledbackException txException = new TransactionRolledbackException(message);
        throw new InvalidateReferenceException((Exception)txException);
    }
}

