/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.transaction.TransactionRequiredException;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.stateful.StatefulInstanceManager;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.Logger;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;

public class StatefulContainer
implements RpcContainer,
TransactionContainer {
    StatefulInstanceManager instanceManager;
    HashMap deploymentRegistry;
    Object containerID = null;
    Method EJB_REMOVE_METHOD = null;
    protected static final Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");

    public void init(Object id, HashMap registry, Properties properties) throws OpenEJBException {
        this.containerID = id;
        this.deploymentRegistry = registry;
        if (properties == null) {
            properties = new Properties();
        }
        SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulContainer");
        SafeProperties safeProps = toolkit.getSafeProperties(properties);
        try {
            String className = safeProps.getProperty("InstanceManager", "org.openejb.core.stateful.StatefulInstanceManager");
            ClassLoader cl = ClasspathUtils.getContextClassLoader();
            this.instanceManager = (StatefulInstanceManager)Class.forName(className, true, cl).newInstance();
        }
        catch (Exception e) {
            throw new SystemException("Initialization of InstanceManager for the \"" + this.containerID + "\" stateful container failed", e);
        }
        this.instanceManager.init(properties);
        DeploymentInfo[] deploys = this.deployments();
        for (int x = 0; x < deploys.length; ++x) {
            org.openejb.core.DeploymentInfo di = (org.openejb.core.DeploymentInfo)deploys[x];
            di.setContainer(this);
        }
        try {
            this.EJB_REMOVE_METHOD = SessionBean.class.getMethod("ejbRemove", new Class[0]);
        }
        catch (NoSuchMethodException nse) {
            throw new SystemException("Fixed remove method can not be initated", nse);
        }
    }

    public DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return (DeploymentInfo)this.deploymentRegistry.get(deploymentID);
    }

    public int getContainerType() {
        return 2;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public void deploy(Object deploymentID, DeploymentInfo info) throws OpenEJBException {
        HashMap registry = (HashMap)this.deploymentRegistry.clone();
        registry.put(deploymentID, info);
        this.deploymentRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        try {
            org.openejb.core.DeploymentInfo deployInfo = (org.openejb.core.DeploymentInfo)this.getDeploymentInfo(deployID);
            ThreadContext callContext = ThreadContext.getThreadContext();
            callContext.set(deployInfo, primKey, securityIdentity);
            boolean authorized = OpenEJB.getSecurityService().isCallerAuthorized(securityIdentity, deployInfo.getAuthorizedRoles(callMethod));
            if (!authorized) {
                throw new ApplicationException(new RemoteException("Unauthorized Access by Principal Denied"));
            }
            Class<?> declaringClass = callMethod.getDeclaringClass();
            String methodName = callMethod.getName();
            if (EJBHome.class.isAssignableFrom(declaringClass) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (methodName.equals("create")) {
                    ProxyInfo proxyInfo = this.createEJBObject(callMethod, args, callContext);
                    return proxyInfo;
                }
                if (methodName.equals("remove")) {
                    this.removeEJBObject(callMethod, args, callContext);
                    Object var11_12 = null;
                    return var11_12;
                }
            } else if ((EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) && methodName.equals("remove")) {
                this.removeEJBObject(callMethod, args, callContext);
                Object var11_13 = null;
                return var11_13;
            }
            SessionBean bean = null;
            bean = this.instanceManager.obtainInstance(primKey, callContext);
            callContext.setCurrentOperation((byte)1);
            Object returnValue = null;
            Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
            returnValue = this.invoke(callMethod, runMethod, args, (EnterpriseBean)bean, callContext);
            this.instanceManager.poolInstance(primKey, (EnterpriseBean)bean);
            Object object = deployInfo.convertIfLocalReference(callMethod, returnValue);
            return object;
        }
        finally {
            ThreadContext.setThreadContext(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(Method callMethod, Method runMethod, Object[] args, EnterpriseBean bean, ThreadContext callContext) throws OpenEJBException {
        TransactionPolicy txPolicy = callContext.getDeploymentInfo().getTransactionPolicy(callMethod);
        TransactionContext txContext = new TransactionContext(callContext);
        try {
            txPolicy.beforeInvoke(bean, txContext);
        }
        catch (ApplicationException e) {
            if (e.getRootCause() instanceof TransactionRequiredException || e.getRootCause() instanceof RemoteException) {
                this.instanceManager.poolInstance(callContext.getPrimaryKey(), bean);
            }
            throw e;
        }
        Object returnValue = null;
        try {
            returnValue = runMethod.invoke((Object)bean, args);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                txPolicy.handleSystemException(ite.getTargetException(), bean, txContext);
            } else {
                this.instanceManager.poolInstance(callContext.getPrimaryKey(), bean);
                txPolicy.handleApplicationException(ite.getTargetException(), txContext);
            }
        }
        catch (Throwable re) {
            txPolicy.handleSystemException(re, bean, txContext);
        }
        finally {
            txPolicy.afterInvoke(bean, txContext);
        }
        return returnValue;
    }

    public StatefulInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        try {
            SessionBean bean = this.instanceManager.obtainInstance(callContext.getPrimaryKey(), callContext);
            if (bean != null) {
                callContext.setCurrentOperation((byte)5);
                this.invoke(callMethod, this.EJB_REMOVE_METHOD, null, (EnterpriseBean)bean, callContext);
            }
        }
        finally {
            this.instanceManager.freeInstance(callContext.getPrimaryKey());
        }
    }

    protected ProxyInfo createEJBObject(Method callMethod, Object[] args, ThreadContext callContext) throws OpenEJBException {
        org.openejb.core.DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Class beanType = deploymentInfo.getBeanClass();
        Object primaryKey = this.newPrimaryKey();
        callContext.setPrimaryKey(primaryKey);
        EnterpriseBean bean = this.instanceManager.newInstance(primaryKey, beanType);
        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
        callContext.setCurrentOperation((byte)8);
        this.invoke(callMethod, runMethod, args, bean, callContext);
        this.instanceManager.poolInstance(primaryKey, bean);
        Class<?> callingClass = callMethod.getDeclaringClass();
        boolean isLocalInterface = EJBLocalHome.class.isAssignableFrom(callingClass);
        return new ProxyInfo((DeploymentInfo)deploymentInfo, primaryKey, isLocalInterface, (RpcContainer)this);
    }

    protected Object newPrimaryKey() {
        return new VMID();
    }

    public void discardInstance(EnterpriseBean bean, ThreadContext threadContext) {
        try {
            Object primaryKey = threadContext.getPrimaryKey();
            this.instanceManager.freeInstance(primaryKey);
        }
        catch (Throwable t) {
            logger.error("", t);
        }
    }
}

