/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateful;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.IntraVmCopyMonitor;
import org.openejb.core.stateful.BeanEntry;
import org.openejb.core.stateful.PassivationStrategy;
import org.openejb.util.Logger;
import org.openejb.util.OpenEJBErrorHandler;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;

public class StatefulInstanceManager {
    protected long timeOUT = 0L;
    protected Hashtable beanINDEX = new Hashtable();
    protected BeanEntryQue lruQUE;
    protected PassivationStrategy passivator;
    protected int BULK_PASSIVATION_SIZE = 100;
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulInstanceManager");
    public Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");

    public void init(Properties props) throws OpenEJBException {
        SafeProperties safeProps = this.toolkit.getSafeProperties(props);
        String passivatorClass = null;
        try {
            passivatorClass = safeProps.getProperty("Passivator");
        }
        catch (OpenEJBException e) {
            try {
                passivatorClass = safeProps.getProperty("org/openejb/core/InstanceManager/PASSIVATOR");
            }
            catch (OpenEJBException e1) {
                throw e;
            }
        }
        try {
            this.passivator = (PassivationStrategy)this.toolkit.newInstance(passivatorClass);
        }
        catch (Exception e) {
            OpenEJBErrorHandler.propertyValueIsIllegal("Passivator", passivatorClass, e.getLocalizedMessage());
        }
        this.passivator.init(props);
        int poolSize = safeProps.getPropertyAsInt("PoolSize", 100);
        int timeOutInMinutes = safeProps.getPropertyAsInt("TimeOut", 5);
        int bulkPassivationSize = safeProps.getPropertyAsInt("BulkPassivate", (int)((double)poolSize * 0.25));
        this.lruQUE = new BeanEntryQue(poolSize);
        this.BULK_PASSIVATION_SIZE = bulkPassivationSize > poolSize ? poolSize : bulkPassivationSize;
        this.timeOUT = timeOutInMinutes * 60 * 1000;
    }

    public Object getAncillaryState(Object primaryKey) throws OpenEJBException {
        return this.getBeanEntry((Object)primaryKey).ancillaryState;
    }

    public void setAncillaryState(Object primaryKey, Object ancillaryState) throws OpenEJBException {
        BeanEntry entry = this.getBeanEntry(primaryKey);
        entry.ancillaryState = ancillaryState;
        if (ancillaryState instanceof Transaction) {
            entry.transaction = (Transaction)ancillaryState;
        }
    }

    public EnterpriseBean newInstance(Object primaryKey, Class beanClass) throws OpenEJBException {
        return this.newInstance(primaryKey, null, beanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnterpriseBean newInstance(Object primaryKey, Object ancillaryState, Class beanClass) throws OpenEJBException {
        SessionBean bean = null;
        try {
            bean = (SessionBean)this.toolkit.newInstance(beanClass);
        }
        catch (OpenEJBException oee) {
            this.logger.error("Can't instantiate new instance of class +" + beanClass.getName() + ". Received exception " + oee, oee);
            throw (SystemException)oee;
        }
        ThreadContext thrdCntx = ThreadContext.getThreadContext();
        byte currentOp = thrdCntx.getCurrentOperation();
        thrdCntx.setCurrentOperation((byte)6);
        try {
            bean.setSessionContext((SessionContext)thrdCntx.getDeploymentInfo().getEJBContext());
        }
        catch (Throwable callbackException) {
            this.handleCallbackException(callbackException, (EnterpriseBean)bean, thrdCntx, "setSessionContext");
        }
        finally {
            thrdCntx.setCurrentOperation(currentOp);
        }
        BeanEntry entry = new BeanEntry(bean, primaryKey, ancillaryState, this.timeOUT);
        this.beanINDEX.put(primaryKey, entry);
        return entry.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionBean obtainInstance(Object primaryKey, ThreadContext callContext) throws OpenEJBException {
        if (primaryKey == null) {
            throw new SystemException(new NullPointerException("Cannot obtain an instance of the stateful session bean with a null session id"));
        }
        BeanEntry entry = (BeanEntry)this.beanINDEX.get(primaryKey);
        if (entry == null) {
            entry = this.activate(primaryKey);
            if (entry != null) {
                if (entry.isTimedOut()) {
                    throw new InvalidateReferenceException(new NoSuchObjectException("Timed Out"));
                }
                byte currentOp = callContext.getCurrentOperation();
                callContext.setCurrentOperation((byte)10);
                try {
                    entry.bean.ejbActivate();
                }
                catch (Throwable callbackException) {
                    this.handleCallbackException(callbackException, (EnterpriseBean)entry.bean, callContext, "ejbActivate");
                }
                finally {
                    callContext.setCurrentOperation(currentOp);
                }
                this.beanINDEX.put(primaryKey, entry);
                return entry.bean;
            }
            throw new InvalidateReferenceException(new NoSuchObjectException("Not Found"));
        }
        if (entry.transaction != null) {
            try {
                if (entry.transaction.getStatus() == 0) {
                    return entry.bean;
                }
                entry.transaction = null;
                return entry.bean;
            }
            catch (javax.transaction.SystemException se) {
                throw new SystemException(se);
            }
            catch (IllegalStateException ise) {
                throw new SystemException(ise);
            }
            catch (SecurityException lse) {
                throw new SystemException(lse);
            }
        }
        BeanEntry queEntry = this.lruQUE.remove(entry);
        if (queEntry != null) {
            if (entry.isTimedOut()) {
                entry = (BeanEntry)this.beanINDEX.remove(entry.primaryKey);
                this.handleTimeout(entry, callContext);
                throw new InvalidateReferenceException(new NoSuchObjectException("Stateful SessionBean has timed-out"));
            }
            return entry.bean;
        }
        byte currentOperation = callContext.getCurrentOperation();
        if (currentOperation == 3 || currentOperation == 4) {
            return entry.bean;
        }
        throw new ApplicationException(new RemoteException("Concurrent calls not allowed"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTimeout(BeanEntry entry, ThreadContext thrdCntx) {
        byte currentOp = thrdCntx.getCurrentOperation();
        thrdCntx.setCurrentOperation((byte)5);
        try {
            try {
                entry.bean.ejbRemove();
            }
            catch (Throwable callbackException) {
                String logMessage = "An unexpected exception occured while invoking the ejbRemove method on the timed-out Stateful SessionBean instance; " + callbackException.getClass().getName() + " " + callbackException.getMessage();
                this.logger.error(logMessage);
                Object var7_5 = null;
                this.logger.info("Removing the timed-out stateful session bean instance " + entry.primaryKey);
                thrdCntx.setCurrentOperation(currentOp);
            }
            Object var7_4 = null;
            this.logger.info("Removing the timed-out stateful session bean instance " + entry.primaryKey);
            thrdCntx.setCurrentOperation(currentOp);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.logger.info("Removing the timed-out stateful session bean instance " + entry.primaryKey);
            thrdCntx.setCurrentOperation(currentOp);
            throw throwable;
        }
    }

    public void poolInstance(Object primaryKey, EnterpriseBean bean) throws OpenEJBException {
        if (primaryKey == null || bean == null) {
            throw new SystemException("Invalid arguments");
        }
        BeanEntry entry = (BeanEntry)this.beanINDEX.get(primaryKey);
        if (entry == null) {
            entry = this.activate(primaryKey);
            if (entry == null) {
                throw new SystemException("Invalid primaryKey:" + primaryKey);
            }
        } else if (entry.bean != bean) {
            throw new SystemException("Invalid ID for bean");
        }
        if (entry.transaction != null && entry.transaction == entry.ancillaryState) {
            return;
        }
        try {
            entry.transaction = OpenEJB.getTransactionManager().getTransaction();
        }
        catch (javax.transaction.SystemException se) {
            throw new SystemException("TransactionManager failure");
        }
        if (entry.transaction == null) {
            this.lruQUE.add(entry);
        }
    }

    public EnterpriseBean freeInstance(Object primaryKey) throws SystemException {
        BeanEntry entry = null;
        entry = (BeanEntry)this.beanINDEX.remove(primaryKey);
        if (entry == null) {
            entry = this.activate(primaryKey);
        } else {
            this.lruQUE.remove(entry);
        }
        if (entry == null) {
            return null;
        }
        return entry.bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate() throws SystemException {
        ThreadContext thrdCntx = ThreadContext.getThreadContext();
        Hashtable<Object, BeanEntry> stateTable = new Hashtable<Object, BeanEntry>(this.BULK_PASSIVATION_SIZE);
        byte currentOp = thrdCntx.getCurrentOperation();
        try {
            for (int i = 0; i < this.BULK_PASSIVATION_SIZE; ++i) {
                BeanEntry currentEntry = this.lruQUE.first();
                if (currentEntry == null) {
                    break;
                }
                this.beanINDEX.remove(currentEntry.primaryKey);
                if (currentEntry.isTimedOut()) {
                    this.handleTimeout(currentEntry, thrdCntx);
                    continue;
                }
                thrdCntx.setCurrentOperation((byte)11);
                try {
                    currentEntry.bean.ejbPassivate();
                }
                catch (Throwable e) {
                    String logMessage = "An unexpected exception occured while invoking the ejbPassivate method on the Stateful SessionBean instance; " + e.getClass().getName() + " " + e.getMessage();
                    this.logger.error(logMessage);
                }
                stateTable.put(currentEntry.primaryKey, currentEntry);
            }
        }
        finally {
            thrdCntx.setCurrentOperation(currentOp);
        }
        try {
            IntraVmCopyMonitor.prePassivationOperation();
            this.passivator.passivate(stateTable);
        }
        finally {
            IntraVmCopyMonitor.postPassivationOperation();
        }
    }

    protected BeanEntry activate(Object primaryKey) throws SystemException {
        return (BeanEntry)this.passivator.activate(primaryKey);
    }

    protected InvalidateReferenceException destroy(BeanEntry entry, Exception t) throws SystemException {
        this.beanINDEX.remove(entry.primaryKey);
        this.lruQUE.remove(entry);
        if (entry.transaction != null) {
            try {
                entry.transaction.setRollbackOnly();
            }
            catch (javax.transaction.SystemException se) {
                throw new SystemException(se);
            }
            catch (IllegalStateException ise) {
                throw new SystemException("Attempt to rollback a non-tx context", ise);
            }
            catch (SecurityException lse) {
                throw new SystemException("Container not authorized to rollback tx", lse);
            }
            return new InvalidateReferenceException((Exception)new TransactionRolledbackException(t.getMessage()));
        }
        if (t instanceof RemoteException) {
            return new InvalidateReferenceException(t);
        }
        EJBException ejbE = (EJBException)t;
        return new InvalidateReferenceException(new RemoteException(ejbE.getMessage(), ejbE.getCausedByException()));
    }

    protected BeanEntry getBeanEntry(Object primaryKey) throws OpenEJBException {
        if (primaryKey == null) {
            throw new SystemException(new NullPointerException("The primary key is null. Cannot get the bean entry"));
        }
        BeanEntry entry = (BeanEntry)this.beanINDEX.get(primaryKey);
        if (entry == null) {
            SessionBean bean = this.obtainInstance(primaryKey, ThreadContext.getThreadContext());
            this.poolInstance(primaryKey, (EnterpriseBean)bean);
            entry = (BeanEntry)this.beanINDEX.get(primaryKey);
        }
        return entry;
    }

    protected void handleCallbackException(Throwable e, EnterpriseBean instance, ThreadContext callContext, String callBack) throws ApplicationException, SystemException {
        String remoteMessage = "An unexpected exception occured while invoking the " + callBack + " method on the Stateful SessionBean instance";
        String logMessage = remoteMessage + "; " + e.getClass().getName() + " " + e.getMessage();
        this.logger.error(logMessage);
        Transaction tx = null;
        try {
            tx = this.getTxMngr().getTransaction();
        }
        catch (Throwable t) {
            this.logger.error("Could not retreive the current transaction from the transaction manager while handling a callback exception from the " + callBack + " method of bean " + callContext.getPrimaryKey());
        }
        if (tx != null) {
            this.markTxRollbackOnly(tx);
        }
        this.freeInstance(callContext.getPrimaryKey());
        if (tx == null) {
            throw new InvalidateReferenceException(new RemoteException(remoteMessage, e));
        }
        throw new InvalidateReferenceException((Exception)new TransactionRolledbackException(logMessage));
    }

    protected void markTxRollbackOnly(Transaction tx) throws SystemException {
        try {
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (javax.transaction.SystemException se) {
            throw new SystemException(se);
        }
    }

    protected TransactionManager getTxMngr() {
        return OpenEJB.getTransactionManager();
    }

    class BeanEntryQue {
        private final LinkedList list;
        private final int capacity;

        protected BeanEntryQue(int preferedCapacity) {
            this.capacity = preferedCapacity;
            this.list = new LinkedList();
        }

        protected synchronized BeanEntry first() {
            return (BeanEntry)this.list.removeFirst();
        }

        protected synchronized void add(BeanEntry entry) throws SystemException {
            if (this.list.size() >= this.capacity) {
                StatefulInstanceManager.this.passivate();
            }
            entry.resetTimeOut();
            this.list.addLast(entry);
            entry.inQue = true;
        }

        protected synchronized BeanEntry remove(BeanEntry entry) {
            if (!entry.inQue) {
                return null;
            }
            if (this.list.remove(entry)) {
                entry.inQue = false;
                return entry;
            }
            return null;
        }
    }
}

