/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateless;

import java.rmi.RemoteException;
import javax.ejb.EnterpriseBean;
import org.openejb.ApplicationException;
import org.openejb.Container;
import org.openejb.SystemException;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;

public class StatelessBeanManagedTxPolicy
extends TransactionPolicy {
    public StatelessBeanManagedTxPolicy(TransactionContainer container) {
        this();
        if (container instanceof Container && ((Container)((Object)container)).getContainerType() != 1) {
            throw new IllegalArgumentException();
        }
        this.container = container;
    }

    public StatelessBeanManagedTxPolicy() {
        this.policyType = 6;
    }

    public String policyToString() {
        return "TX_BeanManaged: ";
    }

    public void beforeInvoke(EnterpriseBean instance, TransactionContext context) throws SystemException, ApplicationException {
        context.clientTx = this.suspendTransaction();
    }

    public void afterInvoke(EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        block9: {
            try {
                context.currentTx = this.getTxMngr().getTransaction();
                if (context.currentTx == null) {
                    return;
                }
                if (context.currentTx.getStatus() == 4 || context.currentTx.getStatus() == 3) break block9;
                String message = "The stateless session bean started a transaction but did not complete it.";
                logger.error(message);
                try {
                    this.rollbackTransaction(context.currentTx);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.throwAppExceptionToServer(new RemoteException(message));
            }
            catch (javax.transaction.SystemException e) {
                throw new SystemException(e);
            }
            finally {
                this.resumeTransaction(context.clientTx);
            }
        }
    }

    public void handleApplicationException(Throwable appException, TransactionContext context) throws ApplicationException {
        throw new ApplicationException(appException);
    }

    public void handleSystemException(Throwable sysException, EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        try {
            context.currentTx = this.getTxMngr().getTransaction();
        }
        catch (javax.transaction.SystemException e) {
            context.currentTx = null;
        }
        this.logSystemException(sysException);
        if (context.currentTx != null) {
            this.markTxRollbackOnly(context.currentTx);
        }
        this.discardBeanInstance(instance, context.callContext);
        this.throwExceptionToServer(sysException);
    }
}

