/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import org.openejb.ApplicationException;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJB;
import org.openejb.OpenEJBException;
import org.openejb.ProxyInfo;
import org.openejb.RpcContainer;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.stateless.StatelessInstanceManager;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;

public class StatelessContainer
implements RpcContainer,
TransactionContainer {
    StatelessInstanceManager instanceManager;
    HashMap deploymentRegistry;
    Object containerID = null;

    public void init(Object id, HashMap registry, Properties properties) throws OpenEJBException {
        this.containerID = id;
        this.deploymentRegistry = registry;
        if (properties == null) {
            properties = new Properties();
        }
        SafeToolkit toolkit = SafeToolkit.getToolkit("StatelessContainer");
        SafeProperties safeProps = toolkit.getSafeProperties(properties);
        try {
            String className = safeProps.getProperty("InstanceManager", "org.openejb.core.stateless.StatelessInstanceManager");
            ClassLoader cl = ClasspathUtils.getContextClassLoader();
            this.instanceManager = (StatelessInstanceManager)Class.forName(className, true, cl).newInstance();
        }
        catch (Exception e) {
            throw new SystemException("Initialization of InstanceManager for the \"" + this.containerID + "\" stateful container failed", e);
        }
        this.instanceManager.init(properties);
        DeploymentInfo[] deploys = this.deployments();
        for (int x = 0; x < deploys.length; ++x) {
            org.openejb.core.DeploymentInfo di = (org.openejb.core.DeploymentInfo)deploys[x];
            di.setContainer(this);
        }
    }

    public DeploymentInfo[] deployments() {
        return this.deploymentRegistry.values().toArray(new DeploymentInfo[this.deploymentRegistry.size()]);
    }

    public DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return (DeploymentInfo)this.deploymentRegistry.get(deploymentID);
    }

    public int getContainerType() {
        return 1;
    }

    public Object getContainerID() {
        return this.containerID;
    }

    public void deploy(Object deploymentID, DeploymentInfo info) throws OpenEJBException {
        HashMap registry = (HashMap)this.deploymentRegistry.clone();
        registry.put(deploymentID, info);
        this.deploymentRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        try {
            Class<?> declaringClass;
            org.openejb.core.DeploymentInfo deployInfo = (org.openejb.core.DeploymentInfo)this.getDeploymentInfo(deployID);
            ThreadContext callContext = ThreadContext.getThreadContext();
            callContext.set(deployInfo, primKey, securityIdentity);
            boolean authorized = OpenEJB.getSecurityService().isCallerAuthorized(securityIdentity, deployInfo.getAuthorizedRoles(callMethod));
            if (!authorized) {
                throw new ApplicationException(new RemoteException("Unauthorized Access by Principal Denied"));
            }
            if (EJBHome.class.isAssignableFrom(declaringClass = callMethod.getDeclaringClass()) || EJBLocalHome.class.isAssignableFrom(declaringClass)) {
                if (callMethod.getName().equals("create")) {
                    ProxyInfo proxyInfo = this.createEJBObject(deployInfo, callMethod);
                    return proxyInfo;
                }
                Object var10_11 = null;
                return var10_11;
            }
            if (EJBObject.class == declaringClass || EJBLocalObject.class == declaringClass) {
                Object var10_12 = null;
                return var10_12;
            }
            SessionBean bean = null;
            bean = (SessionBean)this.instanceManager.getInstance(callContext);
            callContext.setCurrentOperation((byte)1);
            Method runMethod = deployInfo.getMatchingBeanMethod(callMethod);
            Object retValue = this.invoke(callMethod, runMethod, args, (EnterpriseBean)bean, callContext);
            this.instanceManager.poolInstance(callContext, (EnterpriseBean)bean);
            Object object = deployInfo.convertIfLocalReference(callMethod, retValue);
            return object;
        }
        finally {
            ThreadContext.setThreadContext(null);
        }
    }

    public StatelessInstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(Method callMethod, Method runMethod, Object[] args, EnterpriseBean bean, ThreadContext callContext) throws OpenEJBException {
        TransactionPolicy txPolicy = callContext.getDeploymentInfo().getTransactionPolicy(callMethod);
        TransactionContext txContext = new TransactionContext();
        txContext.callContext = callContext;
        txPolicy.beforeInvoke(bean, txContext);
        Object returnValue = null;
        try {
            returnValue = runMethod.invoke((Object)bean, args);
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof RuntimeException) {
                txPolicy.handleSystemException(ite.getTargetException(), bean, txContext);
            } else {
                this.instanceManager.poolInstance(callContext, bean);
                txPolicy.handleApplicationException(ite.getTargetException(), txContext);
            }
        }
        catch (Throwable re) {
            txPolicy.handleSystemException(re, bean, txContext);
        }
        finally {
            txPolicy.afterInvoke(bean, txContext);
        }
        return returnValue;
    }

    protected ProxyInfo createEJBObject(org.openejb.core.DeploymentInfo deploymentInfo, Method callMethod) {
        Class<?> callingClass = callMethod.getDeclaringClass();
        boolean isLocalInterface = EJBLocalHome.class.isAssignableFrom(callingClass);
        return new ProxyInfo((DeploymentInfo)deploymentInfo, null, isLocalInterface, (RpcContainer)this);
    }

    public void discardInstance(EnterpriseBean instance, ThreadContext context) {
        this.instanceManager.discardInstance(context, instance);
    }
}

