/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateless;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import org.openejb.RpcContainer;
import org.openejb.core.ThreadContext;
import org.openejb.core.ivm.EjbHomeProxyHandler;
import org.openejb.core.ivm.EjbObjectProxyHandler;
import org.openejb.core.ivm.IntraVmHandle;
import org.openejb.core.stateless.StatelessEjbObjectHandler;
import org.openejb.util.proxy.ProxyManager;

public class StatelessEjbHomeHandler
extends EjbHomeProxyHandler {
    public StatelessEjbHomeHandler(RpcContainer container, Object pk, Object depID) {
        super(container, pk, depID);
    }

    protected Object findX(Method method, Object[] args, Object proxy) throws Throwable {
        throw new UnsupportedOperationException("Stateful beans may not have find methods");
    }

    protected Object removeByPrimaryKey(Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoteException("Session objects are private resources and do not have primary keys");
    }

    protected Object removeWithHandle(Method method, Object[] args, Object proxy) throws Throwable {
        EjbObjectProxyHandler stub;
        IntraVmHandle handle = (IntraVmHandle)args[0];
        Object primKey = handle.getPrimaryKey();
        try {
            stub = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(handle.getEJBObject());
        }
        catch (IllegalArgumentException e) {
            stub = null;
        }
        this.container.invoke(this.deploymentID, method, args, primKey, ThreadContext.getThreadContext().getSecurityIdentity());
        if (stub != null) {
            stub.invalidateReference();
        }
        return null;
    }

    protected EjbObjectProxyHandler newEjbObjectHandler(RpcContainer container, Object pk, Object depID) {
        return new StatelessEjbObjectHandler(container, pk, depID);
    }
}

