/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.stateless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Properties;
import javax.ejb.EnterpriseBean;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.log4j.Category;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJBException;
import org.openejb.SystemException;
import org.openejb.core.DeploymentInfo;
import org.openejb.core.ThreadContext;
import org.openejb.util.LinkedListStack;
import org.openejb.util.SafeProperties;
import org.openejb.util.SafeToolkit;
import org.openejb.util.Stack;

public class StatelessInstanceManager {
    protected HashMap poolMap = new HashMap();
    protected int poolLimit = 0;
    protected int beanCount = 0;
    protected boolean strictPooling = false;
    protected PoolQueue poolQueue = null;
    protected final SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulInstanceManager");
    protected static final Category logger = Category.getInstance((String)"OpenEJB");

    public void init(Properties props) throws OpenEJBException {
        SafeProperties safeProps = this.toolkit.getSafeProperties(props);
        this.poolLimit = safeProps.getPropertyAsInt("PoolSize", 10);
        this.strictPooling = safeProps.getPropertyAsBoolean("StrictPooling", new Boolean(false));
        if (this.strictPooling) {
            int waitTime = safeProps.getPropertyAsInt("TimeOut", 0);
            this.poolQueue = new PoolQueue(waitTime);
        }
    }

    public EnterpriseBean getInstance(ThreadContext callContext) throws OpenEJBException {
        SessionBean bean = null;
        Object deploymentId = callContext.getDeploymentInfo().getDeploymentID();
        Stack pool = (Stack)this.poolMap.get(deploymentId);
        if (pool == null) {
            pool = new LinkedListStack(this.poolLimit);
            this.poolMap.put(deploymentId, pool);
        } else {
            bean = (SessionBean)pool.pop();
        }
        while (this.strictPooling && bean == null && pool.size() >= this.poolLimit) {
            this.poolQueue.waitForAvailableInstance();
            bean = (SessionBean)pool.pop();
        }
        if (bean == null) {
            try {
                Class beanClass = callContext.getDeploymentInfo().getBeanClass();
                bean = (SessionBean)this.toolkit.newInstance(beanClass);
            }
            catch (OpenEJBException oee) {
                throw (SystemException)oee;
            }
            byte originalOperation = callContext.getCurrentOperation();
            try {
                callContext.setCurrentOperation((byte)6);
                DeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
                bean.setSessionContext((SessionContext)deploymentInfo.getEJBContext());
                callContext.setCurrentOperation((byte)8);
                Method createMethod = deploymentInfo.getCreateMethod();
                createMethod.invoke((Object)bean, null);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                String t = "The bean instance " + bean + " threw a system exception:" + e;
                logger.error((Object)t, e);
                throw new ApplicationException(new RemoteException("Can not obtain a free instance."));
            }
            finally {
                callContext.setCurrentOperation(originalOperation);
            }
        }
        return bean;
    }

    public void poolInstance(ThreadContext callContext, EnterpriseBean bean) throws OpenEJBException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        Object deploymentId = callContext.getDeploymentInfo().getDeploymentID();
        Stack pool = (Stack)this.poolMap.get(deploymentId);
        if (this.strictPooling) {
            pool.push(bean);
            this.poolQueue.notifyWaitingThreads();
        } else if (pool.size() > this.poolLimit) {
            this.freeInstance(callContext, bean);
        } else {
            pool.push(bean);
        }
    }

    public void freeInstance(ThreadContext callContext, EnterpriseBean bean) {
        try {
            callContext.setCurrentOperation((byte)5);
            ((SessionBean)bean).ejbRemove();
        }
        catch (Throwable re) {
            logger.error((Object)("The bean instance " + bean + " threw a system exception:" + re), re);
        }
    }

    public void discardInstance(ThreadContext callContext, EnterpriseBean bean) {
    }

    static class PoolQueue {
        private final long waitPeriod;

        public PoolQueue(long time) {
            this.waitPeriod = time;
        }

        public synchronized void waitForAvailableInstance() throws InvalidateReferenceException {
            try {
                this.wait(this.waitPeriod);
            }
            catch (InterruptedException ie) {
                throw new InvalidateReferenceException(new RemoteException("No instance avaiable to service request"));
            }
        }

        public synchronized void notifyWaitingThreads() {
            this.notify();
        }
    }
}

