/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.transaction;

import java.rmi.RemoteException;
import javax.ejb.EnterpriseBean;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionRolledbackException;
import org.openejb.ApplicationException;
import org.openejb.InvalidateReferenceException;
import org.openejb.OpenEJB;
import org.openejb.SystemException;
import org.openejb.core.ThreadContext;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.util.Logger;

public abstract class TransactionPolicy {
    public static final int Mandatory = 0;
    public static final int Never = 1;
    public static final int NotSupported = 2;
    public static final int Required = 3;
    public static final int RequiresNew = 4;
    public static final int Supports = 5;
    public static final int BeanManaged = 6;
    public int policyType;
    private TransactionManager manager;
    protected TransactionContainer container;
    protected static final Logger logger = Logger.getInstance("OpenEJB", "org.openejb.util.resources");
    protected static final Logger txLogger = Logger.getInstance("Transaction", "org.openejb.util.resources");

    protected TransactionManager getTxMngr() {
        if (this.manager == null) {
            this.manager = OpenEJB.getTransactionManager();
        }
        return this.manager;
    }

    public TransactionContainer getContainer() {
        return this.container;
    }

    public String policyToString() {
        return "Internal Error: no such policy";
    }

    public abstract void handleApplicationException(Throwable var1, TransactionContext var2) throws ApplicationException;

    public abstract void handleSystemException(Throwable var1, EnterpriseBean var2, TransactionContext var3) throws ApplicationException, SystemException;

    public abstract void beforeInvoke(EnterpriseBean var1, TransactionContext var2) throws SystemException, ApplicationException;

    public abstract void afterInvoke(EnterpriseBean var1, TransactionContext var2) throws ApplicationException, SystemException;

    protected void markTxRollbackOnly(Transaction tx) throws SystemException {
        try {
            if (tx != null) {
                tx.setRollbackOnly();
                if (txLogger.isInfoEnabled()) {
                    txLogger.info(this.policyToString() + "setRollbackOnly() on transaction " + tx);
                }
            }
        }
        catch (javax.transaction.SystemException se) {
            logger.error("Exception during setRollbackOnly()", se);
            throw new SystemException(se);
        }
    }

    protected Transaction suspendTransaction() throws SystemException {
        try {
            Transaction tx = this.getTxMngr().suspend();
            if (txLogger.isInfoEnabled()) {
                txLogger.info(this.policyToString() + "Suspended transaction " + tx);
            }
            return tx;
        }
        catch (javax.transaction.SystemException se) {
            logger.error("Exception during suspend()", se);
            throw new SystemException(se);
        }
    }

    protected void resumeTransaction(Transaction tx) throws SystemException {
        try {
            if (tx == null) {
                if (txLogger.isInfoEnabled()) {
                    txLogger.info(this.policyToString() + "No transaction to resume");
                }
            } else {
                if (txLogger.isInfoEnabled()) {
                    txLogger.info(this.policyToString() + "Resuming transaction " + tx);
                }
                this.getTxMngr().resume(tx);
            }
        }
        catch (InvalidTransactionException ite) {
            txLogger.error("Could not resume the client's transaction, the transaction is no longer valid: " + ite.getMessage());
            throw new SystemException(ite);
        }
        catch (IllegalStateException e) {
            txLogger.error("Could not resume the client's transaction: " + e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("Could not resume the client's transaction: The transaction reported a system exception: " + e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void commitTransaction(Transaction tx) throws SystemException {
        try {
            if (txLogger.isInfoEnabled()) {
                txLogger.info(this.policyToString() + "Committing transaction " + tx);
            }
            if (tx.equals(this.getTxMngr().getTransaction())) {
                this.getTxMngr().commit();
            } else {
                tx.commit();
            }
        }
        catch (RollbackException e) {
            txLogger.info("The transaction has been rolled back rather than commited: " + e.getMessage());
        }
        catch (HeuristicMixedException e) {
            txLogger.info("A heuristic decision was made, some relevant updates have been committed while others have been rolled back: " + e.getMessage());
        }
        catch (HeuristicRollbackException e) {
            txLogger.info("A heuristic decision was made while commiting the transaction, some relevant updates have been rolled back: " + e.getMessage());
        }
        catch (SecurityException e) {
            txLogger.error("The current thread is not allowed to commit the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
        catch (IllegalStateException e) {
            txLogger.error("The current thread is not associated with a transaction: " + e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            txLogger.error("The Transaction Manager has encountered an unexpected error condition while attempting to commit the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void rollbackTransaction(Transaction tx) throws SystemException {
        try {
            if (txLogger.isInfoEnabled()) {
                txLogger.info(this.policyToString() + "Rolling back transaction " + tx);
            }
            if (tx.equals(this.getTxMngr().getTransaction())) {
                this.getTxMngr().rollback();
            } else {
                tx.rollback();
            }
        }
        catch (IllegalStateException e) {
            logger.error("The TransactionManager reported an exception while attempting to rollback the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
        catch (javax.transaction.SystemException e) {
            logger.error("The TransactionManager reported an exception while attempting to rollback the transaction: " + e.getMessage());
            throw new SystemException(e);
        }
    }

    protected void throwAppExceptionToServer(Throwable appException) throws ApplicationException {
        throw new ApplicationException(appException);
    }

    protected void throwTxExceptionToServer(Throwable sysException) throws ApplicationException {
        String message = "The transaction was rolled back because the bean encountered a non-application exception :" + sysException.getClass().getName() + " : " + sysException.getMessage();
        TransactionRolledbackException txException = new TransactionRolledbackException(message);
        throw new InvalidateReferenceException((Exception)txException);
    }

    protected void throwExceptionToServer(Throwable sysException) throws ApplicationException {
        RemoteException re = new RemoteException("The bean encountered a non-application exception.", sysException);
        throw new InvalidateReferenceException(re);
    }

    protected void logSystemException(Throwable sysException) {
        logger.error("The bean instances business method encountered a system exception:" + sysException.getMessage(), sysException);
    }

    protected void discardBeanInstance(EnterpriseBean instance, ThreadContext callContext) {
        this.container.discardInstance(instance, callContext);
    }

    protected void beginTransaction() throws javax.transaction.SystemException {
        try {
            this.getTxMngr().begin();
            if (txLogger.isInfoEnabled()) {
                txLogger.info(this.policyToString() + "Started transaction " + this.getTxMngr().getTransaction());
            }
        }
        catch (NotSupportedException nse) {
            logger.error("", nse);
        }
    }

    protected void handleCallbackException() {
    }
}

