/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.transaction;

import javax.ejb.EnterpriseBean;
import javax.transaction.InvalidTransactionException;
import org.openejb.ApplicationException;
import org.openejb.SystemException;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;

public class TxNotSupported
extends TransactionPolicy {
    public TxNotSupported(TransactionContainer container) {
        this();
        this.container = container;
    }

    public TxNotSupported() {
        this.policyType = 2;
    }

    public String policyToString() {
        return "TX_NotSupported: ";
    }

    public void beforeInvoke(EnterpriseBean instance, TransactionContext context) throws SystemException, ApplicationException {
        try {
            context.clientTx = this.getTxMngr().suspend();
        }
        catch (javax.transaction.SystemException se) {
            throw new SystemException(se);
        }
        context.currentTx = null;
    }

    public void afterInvoke(EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        if (context.clientTx != null) {
            try {
                this.getTxMngr().resume(context.clientTx);
            }
            catch (InvalidTransactionException ite) {
                logger.error("Could not resume the client's transaction, the transaction is no longer valid: " + ite.getMessage());
            }
            catch (IllegalStateException e) {
                logger.error("Could not resume the client's transaction: " + e.getMessage());
            }
            catch (javax.transaction.SystemException e) {
                logger.error("Could not resume the client's transaction: The transaction reported a system exception: " + e.getMessage());
            }
        }
    }

    public void handleApplicationException(Throwable appException, TransactionContext context) throws ApplicationException {
        throw new ApplicationException(appException);
    }

    public void handleSystemException(Throwable sysException, EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        this.logSystemException(sysException);
        this.discardBeanInstance(instance, context.callContext);
        this.throwExceptionToServer(sysException);
    }
}

