/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.core.transaction;

import javax.ejb.EnterpriseBean;
import org.openejb.ApplicationException;
import org.openejb.SystemException;
import org.openejb.core.transaction.TransactionContainer;
import org.openejb.core.transaction.TransactionContext;
import org.openejb.core.transaction.TransactionPolicy;

public class TxRequired
extends TransactionPolicy {
    public TxRequired(TransactionContainer container) {
        this();
        this.container = container;
    }

    public TxRequired() {
        this.policyType = 3;
    }

    public String policyToString() {
        return "TX_Required: ";
    }

    public void beforeInvoke(EnterpriseBean instance, TransactionContext context) throws SystemException, ApplicationException {
        try {
            context.clientTx = this.getTxMngr().getTransaction();
            if (context.clientTx == null) {
                this.beginTransaction();
            }
            context.currentTx = this.getTxMngr().getTransaction();
        }
        catch (javax.transaction.SystemException se) {
            logger.error("Exception during getTransaction()", se);
            throw new SystemException(se);
        }
    }

    public void afterInvoke(EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        try {
            if (context.clientTx != null) {
                return;
            }
            if (context.currentTx.getStatus() == 0) {
                this.commitTransaction(context.currentTx);
            } else {
                this.rollbackTransaction(context.currentTx);
            }
        }
        catch (javax.transaction.SystemException se) {
            logger.error("Exception during getTransaction()", se);
            throw new SystemException(se);
        }
    }

    public void handleApplicationException(Throwable appException, TransactionContext context) throws ApplicationException {
        throw new ApplicationException(appException);
    }

    public void handleSystemException(Throwable sysException, EnterpriseBean instance, TransactionContext context) throws ApplicationException, SystemException {
        boolean runningInContainerTransaction;
        this.logSystemException(sysException);
        boolean bl = runningInContainerTransaction = !context.currentTx.equals(context.clientTx);
        if (runningInContainerTransaction) {
            this.markTxRollbackOnly(context.currentTx);
            this.discardBeanInstance(instance, context.callContext);
            this.throwExceptionToServer(sysException);
        } else {
            this.markTxRollbackOnly(context.clientTx);
            this.discardBeanInstance(instance, context.callContext);
            this.throwTxExceptionToServer(sysException);
        }
    }
}

