/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.util.Hashtable;
import org.openejb.loader.Loader;
import org.openejb.util.ClasspathUtils;

public class EmbeddingLoader
implements Loader {
    static boolean loaded = false;

    public void load(Hashtable env) throws Exception {
        if (loaded) {
            return;
        }
        ClassLoader cl = ClasspathUtils.getContextClassLoader();
        try {
            cl.loadClass("org.openejb.OpenEJB");
        }
        catch (Exception e) {
            this.importOpenEJBLibraries(env);
        }
        try {
            Loader embedded = null;
            Class<?> loaderClass = cl.loadClass("org.openejb.loader.EmbeddedLoader");
            embedded = (Loader)loaderClass.newInstance();
            embedded.load(env);
        }
        catch (Exception e) {
            throw new Exception("Cannot embed OpenEJB. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
        loaded = true;
    }

    private void importOpenEJBLibraries(Hashtable env) throws Exception {
        try {
            String openejbLoader = (String)env.get("openejb.loader");
            ClasspathUtils.addJarsToPath("lib", openejbLoader == null ? "tomcat" : openejbLoader, env);
            ClasspathUtils.addJarsToPath("dist", openejbLoader == null ? "tomcat" : openejbLoader, env);
        }
        catch (Exception e) {
            throw new Exception("Could not load OpenEJB libraries. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
    }
}

