/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class LoaderServlet
extends HttpServlet {
    String NO_HOME = "The openejb.home is not set.";
    String BAD_HOME = "Invalid openejb.home: ";
    String NOT_THERE = "The path specified does not exist.";
    String NOT_DIRECTORY = "The path specified is not a directory.";
    String NO_DIST = "The path specified is not correct, it does not contain a 'dist' directory.";
    String NO_LIBS = "The path specified is not correct, it does not contain any OpenEJB libraries.";
    String INSTRUCTIONS = "Please edit the web.xml of the openejb_loader webapp and set the openejb.home init-param to the full path where OpenEJB is installed.";

    public void init(ServletConfig config) throws ServletException {
        try {
            Properties p = new Properties();
            p.put("java.naming.factory.initial", "org.openejb.client.LocalInitialContextFactory");
            Enumeration enumeration = config.getInitParameterNames();
            System.out.println("OpenEJB init-params:");
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = config.getInitParameter(name);
                p.put(name, value);
                System.out.println("\tparam-name: " + name + ", param-value: " + value);
            }
            String openejbLoaderPropValue = p.getProperty("openejb.loader");
            if (openejbLoaderPropValue != null && openejbLoaderPropValue.endsWith("tomcat-webapp") && p.getProperty("openejb.base") == null) {
                ServletContext ctx = config.getServletContext();
                p.setProperty("openejb.base", ctx.getRealPath("WEB-INF"));
            }
            new InitialContext(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkOpenEjbHome() throws ServletException {
        try {
            File openejbHomeDist;
            File openejbHome;
            String homePath = System.getProperty("openejb.home");
            if (homePath == null) {
                this.handleError(this.NO_HOME, this.INSTRUCTIONS);
            }
            if (!(openejbHome = new File(homePath)).exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_THERE, this.INSTRUCTIONS);
            }
            if (!openejbHome.isDirectory()) {
                this.handleError(this.BAD_HOME + homePath, this.NOT_DIRECTORY, this.INSTRUCTIONS);
            }
            if (!(openejbHomeDist = new File(openejbHome, "dist")).exists()) {
                this.handleError(this.BAD_HOME + homePath, this.NO_DIST, this.INSTRUCTIONS);
            }
            String[] libs = openejbHomeDist.list();
            boolean found = false;
            for (int i = 0; i < libs.length && !found; ++i) {
                found = libs[i].startsWith("openejb-") && libs[i].endsWith(".jar");
            }
            if (!found) {
                this.handleError(this.BAD_HOME + homePath, this.NO_LIBS, this.INSTRUCTIONS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleError(String m1, String m2, String m3) throws ServletException {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println(m3);
        System.err.println("---------------------------------------------------");
        throw new ServletException(m1 + " " + m2 + " " + m3);
    }

    private void handleError(String m1, String m2) throws ServletException {
        System.err.println("--[PLEASE FIX]-------------------------------------");
        System.err.println(m1);
        System.err.println(m2);
        System.err.println("---------------------------------------------------");
        throw new ServletException(m1 + " " + m2);
    }
}

