/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.loader;

import java.util.Hashtable;
import org.openejb.loader.Loader;
import org.openejb.util.ClasspathUtils;

public class SystemLoader
implements Loader {
    static boolean loaded = false;

    public void load(Hashtable env) throws Exception {
        if (loaded) {
            return;
        }
        try {
            Class.forName("org.openejb.OpenEJB");
        }
        catch (Exception e) {
            this.importOpenEJBLibraries(env);
        }
        try {
            Loader embedded = null;
            Class<?> loaderClass = Class.forName("org.openejb.loader.EmbeddedLoader");
            embedded = (Loader)loaderClass.newInstance();
            embedded.load(env);
            ClasspathUtils.rebuildJavaClassPathVariable();
        }
        catch (Exception e) {
            throw new Exception("Cannot embed OpenEJB. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
        loaded = true;
    }

    private void importOpenEJBLibraries(Hashtable env) throws Exception {
        try {
            if (env.get("openejb.home") != null) {
                System.setProperty("openejb.home", (String)env.get("openejb.home"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ClasspathUtils.addJarsToPath("lib", "system");
            ClasspathUtils.addJarsToPath("dist", "system");
        }
        catch (Exception e) {
            throw new Exception("Could not load OpenEJB libraries. Exception: " + e.getClass().getName() + " " + e.getMessage());
        }
    }
}

