/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.openejb.OpenEJB;
import org.openejb.util.HashThreadLocal;

public class SharedLocalConnectionManager
implements ConnectionManager,
ConnectionEventListener,
Serializable {
    private Set connSet;
    private SpecialHashThreadLocal threadLocal = new SpecialHashThreadLocal();
    private HashMap factoryMap = new HashMap();

    public void init(Properties props) {
    }

    public SharedLocalConnectionManager() throws ApplicationServerInternalException {
        this.connSet = Collections.synchronizedSet(new HashSet());
    }

    public Object allocateConnection(ManagedConnectionFactory factory, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        ManagedConnection conn = (ManagedConnection)this.threadLocal.get(factory);
        if (conn == null) {
            conn = factory.matchManagedConnections(this.connSet, null, cxRequestInfo);
            if (conn != null) {
                this.connSet.remove(conn);
            } else {
                conn = factory.createManagedConnection(null, cxRequestInfo);
                conn.addConnectionEventListener((ConnectionEventListener)this);
            }
            conn.getLocalTransaction().begin();
            try {
                Transaction tx = OpenEJB.getTransactionManager().getTransaction();
                if (tx != null) {
                    tx.registerSynchronization((Synchronization)new Synchronizer(conn.getLocalTransaction()));
                }
            }
            catch (SystemException se) {
                throw new ApplicationServerInternalException("Can not obtain a Transaction object from TransactionManager. " + se.getMessage());
            }
            catch (RollbackException re) {
                throw new ApplicationServerInternalException("Can not register org.openejb.resource.LocalTransacton with transaciton manager. Transaction has already been rolled back" + re.getMessage());
            }
            this.threadLocal.put(factory, conn);
        }
        Object handle = conn.getConnection(null, cxRequestInfo);
        return handle;
    }

    public void connectionClosed(ConnectionEvent event) {
        try {
            if (OpenEJB.getTransactionManager().getTransaction() == null) {
                ManagedConnection conn = (ManagedConnection)event.getSource();
                conn.getLocalTransaction().commit();
                this.cleanup(conn);
            }
        }
        catch (SystemException se) {
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        ManagedConnection conn = (ManagedConnection)event.getSource();
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.threadLocal.getKey(conn);
        try {
            conn.destroy();
            if (this.threadLocal.get(mcf) == conn) {
                this.threadLocal.put(mcf, null);
            }
        }
        catch (ResourceException re) {
            // empty catch block
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        this.cleanup((ManagedConnection)event.getSource());
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        this.cleanup((ManagedConnection)event.getSource());
    }

    private void cleanup(ManagedConnection conn) {
        if (conn != null) {
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.threadLocal.getKey(conn);
            try {
                conn.cleanup();
                this.connSet.add(conn);
            }
            catch (ResourceException re) {
                try {
                    conn.destroy();
                }
                catch (ResourceException re2) {
                    // empty catch block
                }
            }
            this.threadLocal.put(mcf, null);
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    class SpecialHashThreadLocal
    extends HashThreadLocal {
        HashMap keyMap = new HashMap();

        SpecialHashThreadLocal() {
        }

        public synchronized void put(Object key, Object value) {
            if (!this.keyMap.containsKey(key)) {
                this.keyMap.put(value, key);
            }
            super.put(key, value);
        }

        public synchronized Object getKey(Object value) {
            return this.keyMap.get(value);
        }
    }

    class Synchronizer
    implements Synchronization {
        LocalTransaction localTx;

        public Synchronizer(LocalTransaction lt) {
            this.localTx = lt;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                try {
                    this.localTx.commit();
                }
                catch (ResourceException re) {
                    throw new RuntimeException("JDBC driver failed to commit transaction. " + re.getMessage());
                }
            }
            try {
                this.localTx.rollback();
            }
            catch (ResourceException re) {
                throw new RuntimeException("JDBC driver failed to rollback transaction. " + re.getMessage());
            }
        }
    }
}

