/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.openejb.resource.jdbc.JdbcManagedConnection;

public class JdbcConnection
implements Connection {
    private Connection physicalConn;
    private JdbcManagedConnection managedConn;
    protected boolean isClosed = false;

    protected JdbcConnection(JdbcManagedConnection managedConn, Connection physicalConn) {
        this.physicalConn = physicalConn;
        this.managedConn = managedConn;
    }

    protected Connection getPhysicalConnection() {
        return this.physicalConn;
    }

    protected JdbcManagedConnection getManagedConnection() {
        return this.managedConn;
    }

    protected void invalidate() {
        this.isClosed = true;
        this.physicalConn = null;
        this.managedConn = null;
    }

    protected void associate(JdbcManagedConnection mngdConn) {
        this.isClosed = false;
        this.managedConn = mngdConn;
        this.physicalConn = mngdConn.getSQLConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.createStatement();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.prepareStatement(sql);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.prepareCall(sql);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nativeSQL(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.nativeSQL(sql);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        throw new SQLException("Method not supported. Commit is managed automatically by container provider");
    }

    public boolean getAutoCommit() throws SQLException {
        throw new SQLException("Method not supported. Commit is managed automatically by container provider");
    }

    public void commit() throws SQLException {
        throw new SQLException("Method not supported. Commit is managed automatically by container provider");
    }

    public void rollback() throws SQLException {
        throw new SQLException("Method not supported. Rollback is managed automatically by container provider");
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.managedConn.connectionClose(this);
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.getMetaData();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                this.physicalConn.setReadOnly(readOnly);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.isReadOnly();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                this.physicalConn.setCatalog(catalog);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCatalog() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.getCatalog();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                this.physicalConn.setTransactionIsolation(level);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.getTransactionIsolation();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.getWarnings();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                this.physicalConn.clearWarnings();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.createStatement(resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.prepareCall(sql, resultSetType, resultSetConcurrency);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTypeMap() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                return this.physicalConn.getTypeMap();
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try {
            Connection connection = this.physicalConn;
            synchronized (connection) {
                this.physicalConn.setTypeMap(map);
            }
        }
        catch (SQLException sqlE) {
            this.managedConn.connectionErrorOccurred(this, sqlE);
            throw sqlE;
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        throw new SQLException("method setHoldability not implemented");
    }

    public int getHoldability() throws SQLException {
        throw new SQLException("method getHoldability not implemented");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("method not implemented");
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("method not implemented");
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("method not implemented");
    }
}

