/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SecurityException;
import javax.sql.DataSource;
import org.openejb.resource.jdbc.JdbcConnectionRequestInfo;
import org.openejb.resource.jdbc.JdbcManagedConnectionFactory;

public class JdbcConnectionFactory
implements DataSource,
Referenceable,
Serializable {
    protected transient JdbcManagedConnectionFactory mngdCxFactory;
    protected transient ConnectionManager cxManager;
    protected transient PrintWriter logWriter;
    protected int logTimeout = 0;
    Reference jndiReference;

    public void setReference(Reference ref) {
        this.jndiReference = ref;
    }

    public Reference getReference() {
        return this.jndiReference;
    }

    public JdbcConnectionFactory(JdbcManagedConnectionFactory mngdCxFactory, ConnectionManager cxManager) throws ResourceException {
        this.mngdCxFactory = mngdCxFactory;
        this.cxManager = cxManager;
        this.logWriter = mngdCxFactory.getLogWriter();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.mngdCxFactory.getDefaultUserName(), this.mngdCxFactory.getDefaultPassword());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        JdbcConnectionRequestInfo conInfo = new JdbcConnectionRequestInfo(username, password, this.mngdCxFactory.getJdbcDriver(), this.mngdCxFactory.getJdbcUrl());
        return this.getConnection(conInfo);
    }

    protected Connection getConnection(JdbcConnectionRequestInfo conInfo) throws SQLException {
        try {
            return (Connection)this.cxManager.allocateConnection((ManagedConnectionFactory)this.mngdCxFactory, (ConnectionRequestInfo)conInfo);
        }
        catch (ApplicationServerInternalException asi) {
            if (asi.getLinkedException() instanceof SQLException) {
                throw (SQLException)asi.getLinkedException();
            }
            throw new SQLException("Error code: " + asi.getErrorCode() + "\nApplication error in ContainerManager" + (asi.getLinkedException() != null ? asi.getLinkedException().getMessage() : ""));
        }
        catch (SecurityException se) {
            if (se.getLinkedException() instanceof SQLException) {
                throw (SQLException)se.getLinkedException();
            }
            throw new SQLException("Error code: " + se.getErrorCode() + "\nAuthentication error. Invalid credentials" + (se.getLinkedException() != null ? se.getLinkedException().getMessage() : ""));
        }
        catch (ResourceAdapterInternalException rai) {
            if (rai.getLinkedException() instanceof SQLException) {
                throw (SQLException)rai.getLinkedException();
            }
            throw new SQLException("Error code: " + rai.getErrorCode() + "\nJDBC Connection problem" + (rai.getLinkedException() != null ? rai.getLinkedException().getMessage() : ""));
        }
        catch (ResourceAllocationException rae) {
            if (rae.getLinkedException() instanceof SQLException) {
                throw (SQLException)rae.getLinkedException();
            }
            throw new SQLException("Error code: " + rae.getErrorCode() + "\nJDBC Connection could not be obtained" + (rae.getLinkedException() != null ? rae.getLinkedException().getMessage() : ""));
        }
        catch (ResourceException re) {
            if (re.getLinkedException() instanceof SQLException) {
                throw (SQLException)re.getLinkedException();
            }
            throw new SQLException("Error code: " + re.getErrorCode() + "\nJDBC Connection Factory problem" + (re.getLinkedException() != null ? re.getLinkedException().getMessage() : ""));
        }
    }

    public int getLoginTimeout() {
        return this.logTimeout;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLoginTimeout(int seconds) {
        this.logTimeout = seconds;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }
}

