/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;
import org.openejb.resource.jdbc.JdbcManagedConnection;
import org.openejb.util.Logger;
import org.openejb.util.Messages;

public class JdbcLocalTransaction
implements LocalTransaction {
    protected Connection sqlConn;
    protected JdbcManagedConnection managedConn;
    protected boolean isActiveTransaction = false;
    protected static Messages messages = new Messages("org.openejb.util.resources");
    protected static Logger logger = Logger.getInstance("OpenEJB.resource.jdbc", "org.openejb.util.resources");

    public JdbcLocalTransaction(JdbcManagedConnection managedConn) {
        this.sqlConn = managedConn.getSQLConnection();
        this.managedConn = managedConn;
    }

    public void begin() throws ResourceException {
        if (this.isActiveTransaction) {
            throw new LocalTransactionException("Invalid transaction context. Transaction already active");
        }
        try {
            this.sqlConn.setAutoCommit(false);
            this.isActiveTransaction = true;
        }
        catch (SQLException sqlE) {
            this.isActiveTransaction = false;
            throw new ResourceAdapterInternalException("Can not begin transaction demarcation. Setting auto-commit to false for transaction chaining failed");
        }
        this.managedConn.localTransactionStarted();
    }

    public void commit() throws ResourceException {
        if (this.isActiveTransaction) {
            this.isActiveTransaction = false;
            try {
                this.sqlConn.commit();
            }
            catch (SQLException sqlE) {
                String msg = messages.format("jdbc.commit.failed", this.formatSqlException(sqlE));
                logger.error(msg);
                throw new LocalTransactionException(msg);
            }
            this.managedConn.localTransactionCommitted();
            try {
                this.sqlConn.setAutoCommit(true);
            }
            catch (SQLException sqlE) {
                throw new ResourceAdapterInternalException("Setting auto-commit to true to end transaction chaining failed");
            }
        }
        throw new LocalTransactionException("Invalid transaction context. No active transaction");
    }

    public void rollback() throws ResourceException {
        if (this.isActiveTransaction) {
            this.isActiveTransaction = false;
            try {
                this.sqlConn.rollback();
            }
            catch (SQLException sqlE) {
                String msg = messages.format("jdbc.rollback.failed", this.formatSqlException(sqlE));
                logger.error(msg);
                throw new LocalTransactionException(msg);
            }
            this.managedConn.localTransactionRolledback();
            try {
                this.sqlConn.setAutoCommit(true);
            }
            catch (SQLException sqlE) {
                throw new ResourceAdapterInternalException("Setting auto-commit to true to end transaction chaining failed");
            }
        }
        throw new LocalTransactionException("Invalid transaction context. No active transaction");
    }

    protected void cleanup() throws ResourceException {
        if (this.isActiveTransaction) {
            this.rollback();
        }
    }

    protected String formatSqlException(SQLException e) {
        return messages.format("jdbc.exception", e.getClass().getName(), e.getMessage(), e.getErrorCode() + "", e.getSQLState());
    }
}

