/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.openejb.resource.jdbc.JdbcConnection;
import org.openejb.resource.jdbc.JdbcConnectionRequestInfo;
import org.openejb.resource.jdbc.JdbcLocalTransaction;
import org.openejb.resource.jdbc.JdbcManagedConnectionFactory;
import org.openejb.resource.jdbc.JdbcManagedConnectionMetaData;

public class JdbcManagedConnection
implements ManagedConnection {
    private JdbcManagedConnectionFactory managedFactory;
    private Connection sqlConn;
    private JdbcConnectionRequestInfo requestInfo;
    private JdbcManagedConnectionMetaData metaData;
    private Vector jdbcConnections = new Vector();
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private PrintWriter logWriter;
    private JdbcLocalTransaction localTransaction;

    public JdbcManagedConnection(JdbcManagedConnectionFactory managedFactory, Connection sqlConn, JdbcConnectionRequestInfo rxInfo) throws ResourceAdapterInternalException {
        this.managedFactory = managedFactory;
        this.requestInfo = rxInfo;
        this.sqlConn = sqlConn;
        this.logWriter = managedFactory.getLogWriter();
        try {
            this.metaData = new JdbcManagedConnectionMetaData(sqlConn.getMetaData());
        }
        catch (SQLException sqlE) {
            throw new ResourceAdapterInternalException("Problem while attempting to access meta data from physical connection", "JDBC_0004");
        }
        this.localTransaction = new JdbcLocalTransaction(this);
    }

    protected Connection getSQLConnection() {
        return this.sqlConn;
    }

    protected JdbcConnectionRequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof JdbcConnection)) {
            throw new ResourceException("Connection object is the wrong type. It must be an instance of JdbcConnection");
        }
        JdbcConnection jdbcConn = (JdbcConnection)connection;
        jdbcConn.associate(this);
    }

    public void cleanup() throws ResourceException {
        Object[] connectionHandles = this.jdbcConnections.toArray();
        for (int i = 0; i < connectionHandles.length; ++i) {
            JdbcConnection handle = (JdbcConnection)connectionHandles[i];
            handle.invalidate();
        }
        this.jdbcConnections.clear();
        this.localTransaction.cleanup();
    }

    public void destroy() throws ResourceException {
        this.cleanup();
        try {
            this.sqlConn.close();
        }
        catch (SQLException sqlE) {
            throw new ResourceAdapterInternalException("Problem attempting to close physical JDBC connection", "JDBC_0003");
        }
        this.managedFactory = null;
        this.sqlConn = null;
        this.listeners.clear();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        JdbcConnection jdbcCon = new JdbcConnection(this, this.sqlConn);
        this.jdbcConnections.add(jdbcCon);
        return jdbcCon;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTransaction;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("Method not implemented");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    protected void localTransactionCommitted() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        Object[] elements = this.listeners.toArray();
        for (int i = 0; i < elements.length; ++i) {
            ConnectionEventListener eventListener = (ConnectionEventListener)elements[i];
            eventListener.localTransactionCommitted(event);
        }
    }

    protected void localTransactionRolledback() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        Object[] elements = this.listeners.toArray();
        for (int i = 0; i < elements.length; ++i) {
            ConnectionEventListener eventListener = (ConnectionEventListener)elements[i];
            eventListener.localTransactionRolledback(event);
        }
    }

    protected void localTransactionStarted() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        Object[] elements = this.listeners.toArray();
        for (int i = 0; i < elements.length; ++i) {
            ConnectionEventListener eventListener = (ConnectionEventListener)elements[i];
            eventListener.localTransactionStarted(event);
        }
    }

    protected void connectionErrorOccurred(JdbcConnection jdbcConn, SQLException sqlE) {
        if (this.logWriter != null) {
            this.logWriter.print("\nJdbcConnection Error: On java.sql.Connection (");
            this.logWriter.print(jdbcConn);
            this.logWriter.println(")");
            this.logWriter.println("Exception Stack trace follows:");
            sqlE.printStackTrace(this.logWriter);
            SQLException temp = sqlE;
            while ((temp = sqlE.getNextException()) != null) {
                temp.printStackTrace(this.logWriter);
            }
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)sqlE);
        Object[] elements = this.listeners.toArray();
        for (int i = 0; i < elements.length; ++i) {
            ConnectionEventListener eventListener = (ConnectionEventListener)elements[i];
            eventListener.connectionErrorOccurred(event);
        }
    }

    protected void connectionClose(JdbcConnection jdbcConn) {
        jdbcConn.invalidate();
        this.jdbcConnections.remove(jdbcConn);
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        Object[] elements = this.listeners.toArray();
        for (int i = 0; i < elements.length; ++i) {
            ConnectionEventListener eventListener = (ConnectionEventListener)elements[i];
            eventListener.connectionClosed(event);
        }
    }

    public String toString() {
        return "JdbcManagedConnection (" + this.sqlConn.toString() + ")";
    }
}

