/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.resource.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.openejb.resource.jdbc.JdbcConnectionFactory;
import org.openejb.resource.jdbc.JdbcConnectionRequestInfo;
import org.openejb.resource.jdbc.JdbcManagedConnection;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.Logger;

public class JdbcManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    protected Logger logger = Logger.getInstance("OpenEJB.connector", "org.openejb.alt.util.resources");
    protected String jdbcDriver;
    protected String jdbcUrl;
    protected String defaultUserName;
    protected String defaultPassword;
    protected PrintWriter logWriter;
    private int hashCode = 0;

    public void init(Properties props) throws ResourceAdapterInternalException {
        this.setDefaultUserName(props.getProperty("UserName"));
        this.setDefaultPassword(props.getProperty("Password"));
        this.setJdbcUrl(props.getProperty("JdbcUrl"));
        this.setJdbcDriver(props.getProperty("JdbcDriver"));
        this.testDriver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testDriver() {
        Connection physicalConn = null;
        try {
            physicalConn = DriverManager.getConnection(this.jdbcUrl, this.defaultUserName, this.defaultPassword);
        }
        catch (Throwable e) {
            this.logger.error("Testing driver failed.  [" + this.jdbcUrl + "]  " + "Could not obtain a physical JDBC connection from the DriverManager." + "\nThe error message was:\n" + e.getMessage() + "\nPossible cause:" + "\n\to JDBC driver classes are not available to OpenEJB" + "\n\to Relative paths are not resolved properly");
        }
        finally {
            try {
                physicalConn.close();
            }
            catch (Exception dontCare) {}
        }
    }

    public void setDefaultUserName(String dun) {
        this.defaultUserName = dun;
    }

    public void setDefaultPassword(String dp) {
        this.defaultPassword = dp;
    }

    public void setJdbcUrl(String url) {
        this.jdbcUrl = url;
    }

    public void setJdbcDriver(String driver) throws ResourceAdapterInternalException {
        this.jdbcDriver = driver;
        try {
            ClassLoader cl = ClasspathUtils.getContextClassLoader();
            Class.forName(this.jdbcDriver, true, cl);
        }
        catch (ClassNotFoundException cnf) {
            ResourceAdapterInternalException raie = new ResourceAdapterInternalException("JDBC Driver class \"" + this.jdbcDriver + "\" not found by class loader", "JDBC_0002");
            throw raie;
        }
    }

    public String getDefaultUserName() {
        return this.defaultUserName;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new NotSupportedException("This connector must be used with an application server connection manager");
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new JdbcConnectionFactory(this, cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        Connection physicalConn;
        JdbcConnectionRequestInfo rxInfo = (JdbcConnectionRequestInfo)cxRequestInfo;
        String userDir = System.getProperty("user.dir");
        try {
            String openejbHome = System.getProperty("openejb.home");
            if (openejbHome != null) {
                System.setProperty("user.dir", openejbHome);
            }
            physicalConn = DriverManager.getConnection(this.jdbcUrl, rxInfo.getUserName(), rxInfo.getPassword());
        }
        catch (SQLException sqlE) {
            EISSystemException eisse = new EISSystemException("Could not obtain a physical JDBC connection from the DriverManager");
            eisse.setLinkedException((Exception)sqlE);
            throw eisse;
        }
        finally {
            System.setProperty("user.dir", userDir);
        }
        return new JdbcManagedConnection(this, physicalConn, rxInfo);
    }

    public boolean equals(Object other) {
        if (other instanceof JdbcManagedConnectionFactory) {
            JdbcManagedConnectionFactory otherMCF = (JdbcManagedConnectionFactory)other;
            if (this.jdbcDriver.equals(otherMCF.jdbcDriver) && this.jdbcUrl.equals(otherMCF.jdbcUrl) && this.defaultUserName.equals(otherMCF.defaultUserName) && this.defaultPassword.equals(otherMCF.defaultPassword)) {
                return true;
            }
        }
        return false;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.jdbcDriver.hashCode() ^ this.jdbcUrl.hashCode() ^ this.defaultUserName.hashCode() ^ this.defaultPassword.hashCode();
        return this.hashCode;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (cxRequestInfo instanceof JdbcConnectionRequestInfo) {
            Object[] connections = connectionSet.toArray();
            for (int i = 0; i < connections.length; ++i) {
                JdbcManagedConnection managedConn = (JdbcManagedConnection)connections[i];
                if (!managedConn.getRequestInfo().equals(cxRequestInfo)) continue;
                return managedConn;
            }
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
    }
}

