/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.ri.sp;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.openejb.spi.TransactionService;

public class PseudoTransactionService
implements TransactionService {
    TransactionManager txm = new MyTransactionManager();
    Hashtable map = new Hashtable();

    public void init(Properties props) {
    }

    public TransactionManager getTransactionManager() {
        return this.txm;
    }

    public class MyTransaction
    implements Transaction {
        Vector registeredSynchronizations = new Vector();
        Vector xaResources = new Vector();
        int status = 0;

        public void commit() throws RollbackException {
            if (this.status == 1) {
                this.rollback();
                throw new RollbackException();
            }
            this.doBeforeCompletion();
            this.doXAResources(3);
            this.status = 3;
            this.doAfterCompletion(3);
            this.registeredSynchronizations = new Vector();
            PseudoTransactionService.this.map.remove(Thread.currentThread());
        }

        public boolean delistResource(XAResource xaRes, int flag) {
            this.xaResources.remove(xaRes);
            return true;
        }

        public boolean enlistResource(XAResource xaRes) {
            this.xaResources.addElement(xaRes);
            return true;
        }

        public int getStatus() {
            return this.status;
        }

        public void registerSynchronization(Synchronization sync) {
            this.registeredSynchronizations.addElement(sync);
        }

        public void rollback() {
            this.doXAResources(4);
            this.doAfterCompletion(4);
            this.status = 4;
            this.registeredSynchronizations = new Vector();
            PseudoTransactionService.this.map.remove(Thread.currentThread());
        }

        public void setRollbackOnly() {
            this.status = 1;
        }

        private void doBeforeCompletion() {
            Enumeration enumeration = this.registeredSynchronizations.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    Synchronization sync = (Synchronization)enumeration.nextElement();
                    sync.beforeCompletion();
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        }

        private void doAfterCompletion(int status) {
            Enumeration enumeration = this.registeredSynchronizations.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    Synchronization sync = (Synchronization)enumeration.nextElement();
                    sync.afterCompletion(status);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        }

        private void doXAResources(int status) {
            Object[] resources = this.xaResources.toArray();
            for (int i = 0; i < resources.length; ++i) {
                XAResource xaRes = (XAResource)resources[i];
                if (status == 3) {
                    try {
                        xaRes.commit(null, true);
                    }
                    catch (XAException xae) {
                        // empty catch block
                    }
                    try {
                        xaRes.end(null, 0x4000000);
                    }
                    catch (XAException xae) {}
                    continue;
                }
                try {
                    xaRes.rollback(null);
                }
                catch (XAException xae) {
                    // empty catch block
                }
                try {
                    xaRes.end(null, 0x20000000);
                    continue;
                }
                catch (XAException xae) {
                    // empty catch block
                }
            }
            this.xaResources = new Vector();
        }
    }

    public class MyTransactionManager
    implements TransactionManager {
        public UserTransaction getUserTransaction(Object txID) {
            return new UserTransaction(this){
                private final /* synthetic */ MyTransactionManager this$1;
                {
                    this.this$1 = this$1;
                }

                public void begin() {
                    this.this$1.begin();
                }

                public void commit() throws RollbackException {
                    this.this$1.commit();
                }

                public int getStatus() throws SystemException {
                    return this.this$1.getStatus();
                }

                public void rollback() {
                    this.this$1.rollback();
                }

                public void setRollbackOnly() {
                    this.this$1.setRollbackOnly();
                }

                public void setTransactionTimeout(int seconds) {
                    this.this$1.setTransactionTimeout(seconds);
                }
            };
        }

        public void begin() {
            MyTransaction tx = new MyTransaction();
            PseudoTransactionService.this.map.put(Thread.currentThread(), tx);
        }

        public void commit() throws RollbackException {
            MyTransaction tx = (MyTransaction)PseudoTransactionService.this.map.remove(Thread.currentThread());
            if (tx == null) {
                throw new IllegalStateException();
            }
            tx.commit();
        }

        public int getStatus() throws SystemException {
            Transaction tx = (Transaction)PseudoTransactionService.this.map.get(Thread.currentThread());
            if (tx == null) {
                return 6;
            }
            return tx.getStatus();
        }

        public Transaction getTransaction() {
            return (Transaction)PseudoTransactionService.this.map.get(Thread.currentThread());
        }

        public void resume(Transaction tx) throws SystemException, InvalidTransactionException {
            Transaction ctx = (Transaction)PseudoTransactionService.this.map.get(Thread.currentThread());
            int status = tx.getStatus();
            if (ctx != null || tx == null || status != 0 && status != 1) {
                throw new InvalidTransactionException();
            }
            PseudoTransactionService.this.map.put(Thread.currentThread(), tx);
        }

        public Transaction suspend() {
            return (Transaction)PseudoTransactionService.this.map.remove(Thread.currentThread());
        }

        public void rollback() {
            MyTransaction tx = (MyTransaction)PseudoTransactionService.this.map.remove(Thread.currentThread());
            if (tx == null) {
                throw new IllegalStateException();
            }
            tx.rollback();
        }

        public void setRollbackOnly() {
            MyTransaction tx = (MyTransaction)PseudoTransactionService.this.map.get(Thread.currentThread());
            if (tx == null) {
                throw new IllegalStateException();
            }
            tx.setRollbackOnly();
        }

        public void setTransactionTimeout(int x) {
        }
    }
}

