/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.openejb.server.DontStartServerException;
import org.openejb.server.Server;
import org.openejb.util.JarUtils;

public class Main {
    public static void main(String[] args) {
        try {
            Properties props = Main.parseArguments(args);
            Main.initServer(props);
        }
        catch (DontStartServerException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Properties parseArguments(String[] args) throws DontStartServerException {
        Properties props = new Properties(System.getProperties());
        try {
            props.put("openejb.server.ip", "127.0.0.1");
            props.put("openejb.server.port", "4201");
            props.put("openejb.server.threads", "20");
            JarUtils.setHandlerSystemProperty();
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.server.ip", args[++i]);
                    continue;
                }
                if (args[i].equals("-p")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.server.port", args[++i]);
                    continue;
                }
                if (args[i].equals("-t")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.server.threads", args[++i]);
                    continue;
                }
                if (args[i].equals("-conf")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.configuration", args[++i]);
                    continue;
                }
                if (args[i].equals("-l")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("log4j.configuration", args[++i]);
                    continue;
                }
                if (args[i].equals("-d")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.home", args[++i]);
                    continue;
                }
                if (args[i].equals("--admin-ip")) {
                    if (args.length <= i + 1) continue;
                    System.setProperty("openejb.server.admin-ip", args[++i]);
                    continue;
                }
                if (args[i].startsWith("--local-copy")) {
                    if (args[i].endsWith("false") || args[i].endsWith("FALSE") || args[i].endsWith("no") || args[i].endsWith("NO")) {
                        System.setProperty("openejb.localcopy", "false");
                        continue;
                    }
                    System.setProperty("openejb.localcopy", "true");
                    continue;
                }
                if (args[i].equals("-help")) {
                    Main.printHelp();
                    throw new DontStartServerException();
                }
                if (args[i].equals("-version")) {
                    Main.printVersion();
                    throw new DontStartServerException();
                }
                if (!args[i].equals("-examples")) continue;
                Main.printExamples();
                throw new DontStartServerException();
            }
            props.setProperty("org/openejb/configuration_factory", "org.openejb.alt.config.ConfigurationFactory");
        }
        catch (Exception re) {
            System.err.println("FATAL ERROR: " + re.getMessage());
            System.err.println("");
            System.err.println("Check logs for more details.");
            System.err.println("");
            throw new DontStartServerException();
        }
        return props;
    }

    private static void printVersion() {
        Properties versionInfo = new Properties();
        try {
            JarUtils.setHandlerSystemProperty();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("OpenEJB Remote Server " + versionInfo.get("version") + "    build: " + versionInfo.get("date") + "-" + versionInfo.get("time"));
        System.out.println("" + versionInfo.get("url"));
    }

    private static void printHelp() {
        String header = "OpenEJB Remote Server ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/ejbserver.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void printExamples() {
        String header = "OpenEJB Remote Server ";
        try {
            JarUtils.setHandlerSystemProperty();
            Properties versionInfo = new Properties();
            versionInfo.load(new URL("resource:/openejb-version.properties").openConnection().getInputStream());
            header = header + versionInfo.get("version");
        }
        catch (IOException e) {
            // empty catch block
        }
        System.out.println(header);
        try {
            InputStream in = new URL("resource:/openejb/ejbserver-examples.txt").openConnection().getInputStream();
            int b = in.read();
            while (b != -1) {
                System.out.write(b);
                b = in.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void initServer(Properties props) throws Exception {
        Server server = new Server();
        server.init(props);
    }
}

