/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openejb.server.ServerService;
import org.openejb.server.ServiceException;

public class ServiceAccessController
implements ServerService {
    ServerService next;
    InetAddress[] allowedHosts;

    public ServiceAccessController(ServerService next) {
        this.next = next;
    }

    public void init(Properties props) throws Exception {
        this.parseAdminIPs(props);
        this.next.init(props);
    }

    public void start() throws ServiceException {
        this.next.start();
    }

    public void stop() throws ServiceException {
        this.next.stop();
    }

    public void service(Socket socket) throws ServiceException, IOException {
        this.next.service(socket);
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.next.getIP();
    }

    public int getPort() {
        return this.next.getPort();
    }

    public void checkHostsAuthorization(InetAddress client, InetAddress server) throws SecurityException {
        boolean authorized = false;
        authorized = client.equals(server);
        for (int i = 0; i < this.allowedHosts.length && !authorized; ++i) {
            authorized = this.allowedHosts[i].equals(client);
        }
        if (!authorized) {
            throw new SecurityException("Host " + client.getHostAddress() + " is not authorized to access this service.");
        }
    }

    private void parseAdminIPs(Properties props) {
        try {
            Vector<InetAddress> addresses = new Vector<InetAddress>();
            InetAddress[] localIps = InetAddress.getAllByName("localhost");
            for (int i = 0; i < localIps.length; ++i) {
                addresses.add(localIps[i]);
            }
            String ipString = props.getProperty("only_from");
            if (ipString != null) {
                StringTokenizer st = new StringTokenizer(ipString, ",");
                while (st.hasMoreTokens()) {
                    String address = null;
                    InetAddress ip = null;
                    try {
                        address = st.nextToken();
                        ip = InetAddress.getByName(address);
                        addresses.add(ip);
                    }
                    catch (Exception e) {}
                }
            }
            this.allowedHosts = new InetAddress[addresses.size()];
            addresses.copyInto(this.allowedHosts);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

