/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.openejb.server.ServerService;
import org.openejb.server.ServiceException;

public class ServiceDaemon
implements ServerService,
Runnable {
    ServerService next;
    Properties props;
    String ip;
    int port;
    ServerSocket serverSocket;
    boolean stop = true;

    public ServiceDaemon(ServerService next) {
        this.next = next;
    }

    public void init(Properties props) throws Exception {
        this.props = props;
        String p = props.getProperty("port");
        this.ip = props.getProperty("bind");
        this.port = Integer.parseInt(p);
        this.next.init(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            if (!this.stop) {
                return;
            }
            this.stop = false;
            try {
                this.serverSocket = new ServerSocket(this.port, 20);
                Thread d = new Thread(this);
                d.setName("service." + this.next.getName() + "@" + d.hashCode());
                d.setDaemon(true);
                d.start();
            }
            catch (Exception e) {
                throw new ServiceException("Service failed to start.", e);
            }
            this.next.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceException {
        ServiceDaemon serviceDaemon = this;
        synchronized (serviceDaemon) {
            if (this.stop) {
                return;
            }
            this.stop = true;
            try {
                this.notifyAll();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.next.stop();
        }
    }

    public synchronized void service(final Socket socket) throws ServiceException, IOException {
        Thread d = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        ServiceDaemon.this.next.service(socket);
                    }
                    catch (SecurityException e) {}
                    finally {
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        });
        d.setDaemon(true);
        d.start();
    }

    public String getName() {
        return this.next.getName();
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public void run() {
        Socket socket = null;
        while (!this.stop) {
            try {
                socket = this.serverSocket.accept();
                if (this.stop) continue;
                this.service(socket);
            }
            catch (SecurityException e) {
            }
            catch (Throwable throwable) {}
        }
    }
}

