/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server;

import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.MDC;
import org.openejb.server.ServerService;
import org.openejb.server.ServiceAccessController;
import org.openejb.server.ServiceDaemon;
import org.openejb.server.ServiceException;
import org.openejb.server.ServiceLogger;
import org.openejb.util.ClasspathUtils;
import org.openejb.util.Logger;
import org.openejb.util.Messages;

public class ServiceManager {
    static Messages messages = new Messages("org.openejb.server.util.resources");
    static Logger logger = Logger.getInstance("OpenEJB.server.remote", "org.openejb.server.util.resources");
    private static ServiceManager manager;
    private static HashMap propsByFile;
    private static HashMap fileByProps;
    private static ServerService[] daemons;
    private boolean stop = false;

    private ServiceManager() {
    }

    public static ServiceManager getManager() {
        if (manager == null) {
            manager = new ServiceManager();
        }
        return manager;
    }

    public void init() throws Exception {
        try {
            MDC.put((String)"SERVER", (Object)"main");
            InetAddress localhost = InetAddress.getLocalHost();
            MDC.put((String)"HOST", (Object)localhost.getHostName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] serviceFiles = new String[]{"admin.properties", "ejbd.properties", "telnet.properties", "webadmin.properties"};
        Vector<ServerService> enabledServers = new Vector<ServerService>();
        for (int i = 0; i < serviceFiles.length; ++i) {
            try {
                Properties props = ServiceManager.getProperties(serviceFiles[i]);
                if (!this.isEnabled(props)) continue;
                ServerService server = this.createService(props);
                server = this.wrapService(server);
                server.init(props);
                enabledServers.add(server);
                continue;
            }
            catch (Throwable e) {
                ServiceManager.logger.i18n.error("service.not.loaded", serviceFiles[i], (Object)e.getMessage());
            }
        }
        daemons = new ServerService[enabledServers.size()];
        enabledServers.copyInto(daemons);
    }

    private static Properties getProperties(String file) throws ServiceException {
        Properties props = (Properties)propsByFile.get(file);
        if (props == null) {
            props = ServiceManager.loadProperties(file);
            propsByFile.put(file, props);
            fileByProps.put(props, file);
        }
        return props;
    }

    private static Properties loadProperties(String file) throws ServiceException {
        Properties props = new Properties();
        try {
            URL url = new URL("resource:/" + file);
            props.load(url.openStream());
        }
        catch (Exception e) {
            throw new ServiceException("Cannot load properties", e);
        }
        return props;
    }

    private ServerService createService(Properties props) throws ServiceException {
        ServerService service = null;
        String serviceClassName = ServiceManager.getRequiredProperty("server", props);
        Class serviceClass = this.loadClass(serviceClassName);
        this.checkImplementation(serviceClass);
        service = this.instantiateService(serviceClass);
        return service;
    }

    private ServerService wrapService(ServerService service) {
        service = new ServiceLogger(service);
        service = new ServiceAccessController(service);
        service = new ServiceDaemon(service);
        return service;
    }

    public synchronized void start() throws ServiceException {
        boolean display;
        boolean bl = display = System.getProperty("openejb.nobanner") == null;
        if (display) {
            System.out.println("  ** Starting Services **");
            this.printRow("NAME", "IP", "PORT");
        }
        for (int i = 0; i < daemons.length; ++i) {
            ServerService d = daemons[i];
            try {
                d.start();
                if (!display) continue;
                this.printRow(d.getName(), d.getIP(), d.getPort() + "");
                continue;
            }
            catch (Exception e) {
                logger.error(d.getName() + " " + d.getIP() + " " + d.getPort() + ": " + e.getMessage());
                if (!display) continue;
                this.printRow(d.getName(), "----", "FAILED");
            }
        }
        if (display) {
            System.out.println("-------");
            System.out.println("Ready!");
        }
        try {
            while (!this.stop) {
                this.wait(Long.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            logger.fatal("Unable to keep the server thread alive. Received exception: " + t.getClass().getName() + " : " + t.getMessage());
        }
        System.out.println("[] exiting vm");
        logger.info("Stopping Remote Server");
    }

    public synchronized void stop() throws ServiceException {
        System.out.println("[] received stop signal");
        this.stop = true;
        for (int i = 0; i < daemons.length; ++i) {
            daemons[i].stop();
        }
        this.notifyAll();
    }

    public void printRow(String col1, String col2, String col3) {
        col1 = col1 + "                    ";
        col1 = col1.substring(0, 20);
        col2 = col2 + "                    ";
        col2 = col2.substring(0, 15);
        col3 = col3 + "                    ";
        col3 = col3.substring(0, 6);
        StringBuffer sb = new StringBuffer(50);
        sb.append("  ").append(col1);
        sb.append(" ").append(col2);
        sb.append(" ").append(col3);
        System.out.println(sb.toString());
    }

    private Class loadClass(String className) throws ServiceException {
        ClassLoader loader = ClasspathUtils.getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = messages.format("service.no.class", className);
            throw new ServiceException(msg);
        }
        return clazz;
    }

    private void checkImplementation(Class clazz) throws ServiceException {
        Class intrfce;
        Class clazz2 = intrfce = ServerService.class;
        if (!intrfce.isAssignableFrom(clazz)) {
            String msg = messages.format("service.bad.impl", clazz.getName(), intrfce.getName());
            throw new ServiceException(msg);
        }
    }

    private ServerService instantiateService(Class clazz) throws ServiceException {
        ServerService service = null;
        try {
            service = (ServerService)clazz.newInstance();
        }
        catch (Throwable t) {
            String msg = messages.format("service.instantiation.err", clazz.getName(), t.getClass().getName(), t.getMessage());
            throw new ServiceException(msg, t);
        }
        return service;
    }

    private boolean isEnabled(Properties props) throws ServiceException {
        String dissabled = props.getProperty("dissabled", "");
        return !dissabled.equalsIgnoreCase("yes") && !dissabled.equalsIgnoreCase("true");
    }

    public static String getRequiredProperty(String name, Properties props) throws ServiceException {
        String value = props.getProperty(name);
        if (value == null) {
            String msg = messages.format("service.missing.property", name, fileByProps.get(props));
            throw new ServiceException(msg);
        }
        return value;
    }

    static {
        propsByFile = new HashMap();
        fileByProps = new HashMap();
    }
}

