/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Start {
    public static void main(String[] args) {
        new Start().start();
    }

    public boolean start() {
        if (!this.connect()) {
            this.forkServerProcess();
            return this.connect(10);
        }
        System.out.println(":: server already started ::");
        return true;
    }

    private void forkServerProcess() {
        try {
            ArrayList<String> cmd = new ArrayList<String>();
            String s = File.separator;
            String java = System.getProperty("java.home") + s + "bin" + s + "java";
            cmd.add(java);
            this.addSystemProperties(cmd);
            cmd.add("-classpath");
            cmd.add(this.getClasspath());
            cmd.add("org.openejb.server.Main");
            String[] command = cmd.toArray(new String[0]);
            Runtime runtime = Runtime.getRuntime();
            Process server = runtime.exec(command);
            InputStream out = server.getInputStream();
            Thread serverOut = new Thread(new Pipe(out, System.out));
            serverOut.setDaemon(true);
            serverOut.start();
            InputStream err = server.getErrorStream();
            Thread serverErr = new Thread(new Pipe(err, System.err));
            serverErr.setDaemon(true);
            serverErr.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start the server.");
        }
    }

    private void addSystemProperties(ArrayList cmd) {
        Set<Map.Entry<Object, Object>> set = System.getProperties().entrySet();
        Iterator<Map.Entry<Object, Object>> iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.matches("^-X.*")) {
                cmd.add(key + value);
                continue;
            }
            if (key.matches("^(java|javax|os|sun|user|file|awt|line|path)\\..*")) continue;
            cmd.add("-D" + key + "=" + value);
        }
    }

    private String getClasspath() {
        String classpath = System.getProperty("java.class.path");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String antLoader = "org.apache.tools.ant.AntClassLoader";
        if (cl.getClass().getName().equals(antLoader)) {
            try {
                Class<?> ant = cl.getClass();
                Method getClasspath = ant.getMethod("getClasspath", new Class[0]);
                classpath = classpath + File.pathSeparator + getClasspath.invoke((Object)cl, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classpath;
    }

    private boolean connect() {
        return this.connect(1);
    }

    private boolean connect(int tries) {
        try {
            Socket socket = new Socket("localhost", 4201);
            OutputStream out = socket.getOutputStream();
        }
        catch (Exception e) {
            if (tries < 2) {
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            return this.connect(--tries);
        }
        return true;
    }

    private final class Pipe
    implements Runnable {
        private final InputStream is;
        private final OutputStream out;

        private Pipe(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        public void run() {
            try {
                int i = this.is.read();
                this.out.write(i);
                while (i != -1) {
                    i = this.is.read();
                    this.out.write(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

