/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server.ejbd;

import java.net.UnknownHostException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.openejb.DeploymentInfo;
import org.openejb.ProxyInfo;
import org.openejb.client.ClientMetaData;
import org.openejb.client.EJBHomeHandle;
import org.openejb.client.EJBHomeHandler;
import org.openejb.client.EJBMetaDataImpl;
import org.openejb.client.EJBObjectHandle;
import org.openejb.client.EJBObjectHandler;
import org.openejb.client.ServerMetaData;
import org.openejb.server.ejbd.CallContext;
import org.openejb.server.ejbd.EjbDaemon;
import org.openejb.spi.ApplicationServer;

class ClientObjectFactory
implements ApplicationServer {
    private final EjbDaemon daemon;
    protected ServerMetaData sMetaData;

    public ClientObjectFactory(EjbDaemon daemon) {
        try {
            this.sMetaData = new ServerMetaData("127.0.0.1", 4201);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.daemon = daemon;
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        return this._getEJBMetaData(call, info);
    }

    public Handle getHandle(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        return this._getHandle(call, info);
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        return this._getHomeHandle(call, info);
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        return this._getEJBObject(call, info);
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        CallContext call = CallContext.getCallContext();
        return this._getEJBHome(call, info);
    }

    protected EJBMetaData _getEJBMetaData(CallContext call, ProxyInfo info) {
        DeploymentInfo deployment = info.getDeploymentInfo();
        int idCode = this.daemon.deploymentIndex.getDeploymentIndex(deployment);
        EJBMetaDataImpl metaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), idCode);
        return metaData;
    }

    protected Handle _getHandle(CallContext call, ProxyInfo info) {
        DeploymentInfo deployment = info.getDeploymentInfo();
        int idCode = this.daemon.deploymentIndex.getDeploymentIndex(deployment);
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            // empty catch block
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), idCode);
        Object primKey = info.getPrimaryKey();
        EJBObjectHandler hanlder = EJBObjectHandler.createEJBObjectHandler(eMetaData, this.sMetaData, cMetaData, primKey);
        return new EJBObjectHandle(hanlder.createEJBObjectProxy());
    }

    protected HomeHandle _getHomeHandle(CallContext call, ProxyInfo info) {
        DeploymentInfo deployment = info.getDeploymentInfo();
        int idCode = this.daemon.deploymentIndex.getDeploymentIndex(deployment);
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), idCode);
        EJBHomeHandler hanlder = EJBHomeHandler.createEJBHomeHandler(eMetaData, this.sMetaData, cMetaData);
        return new EJBHomeHandle(hanlder.createEJBHomeProxy());
    }

    protected EJBObject _getEJBObject(CallContext call, ProxyInfo info) {
        DeploymentInfo deployment = info.getDeploymentInfo();
        int idCode = this.daemon.deploymentIndex.getDeploymentIndex(deployment);
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), idCode);
        Object primKey = info.getPrimaryKey();
        EJBObjectHandler hanlder = EJBObjectHandler.createEJBObjectHandler(eMetaData, this.sMetaData, cMetaData, primKey);
        return hanlder.createEJBObjectProxy();
    }

    protected EJBHome _getEJBHome(CallContext call, ProxyInfo info) {
        DeploymentInfo deployment = info.getDeploymentInfo();
        int idCode = this.daemon.deploymentIndex.getDeploymentIndex(deployment);
        Object securityIdentity = null;
        try {
            securityIdentity = call.getEJBRequest().getClientIdentity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientMetaData cMetaData = new ClientMetaData(securityIdentity);
        EJBMetaDataImpl eMetaData = new EJBMetaDataImpl(deployment.getHomeInterface(), deployment.getRemoteInterface(), deployment.getPrimaryKeyClass(), deployment.getComponentType(), deployment.getDeploymentID().toString(), idCode);
        EJBHomeHandler hanlder = EJBHomeHandler.createEJBHomeHandler(eMetaData, this.sMetaData, cMetaData);
        return hanlder.createEJBHomeProxy();
    }
}

