/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.server.ejbd;

import java.rmi.RemoteException;
import java.util.HashMap;
import org.openejb.DeploymentInfo;
import org.openejb.OpenEJB;
import org.openejb.client.EJBRequest;
import org.openejb.util.Messages;

public class DeploymentIndex {
    Messages messages = new Messages("org.openejb.server.ejbd");
    DeploymentInfo[] deployments = null;
    HashMap index = null;

    public DeploymentIndex() {
        DeploymentInfo[] ds = OpenEJB.deployments();
        this.deployments = new DeploymentInfo[ds.length + 1];
        System.arraycopy(ds, 0, this.deployments, 1, ds.length);
        this.index = new HashMap(this.deployments.length);
        for (int i = 1; i < this.deployments.length; ++i) {
            this.index.put(this.deployments[i].getDeploymentID(), new Integer(i));
        }
    }

    public DeploymentInfo getDeployment(EJBRequest req) throws RemoteException {
        DeploymentInfo info = null;
        if (req.getDeploymentCode() > 0 && req.getDeploymentCode() < this.deployments.length) {
            info = this.deployments[req.getDeploymentCode()];
            if (info == null) {
                throw new RemoteException("The deployement with this ID is null");
            }
            req.setDeploymentId((String)info.getDeploymentID());
            return info;
        }
        if (req.getDeploymentId() == null) {
            throw new RemoteException("Invalid deployment id and code: id=" + req.getDeploymentId() + ": code=" + req.getDeploymentCode());
        }
        int idCode = this.getDeploymentIndex(req.getDeploymentId());
        if (idCode == -1) {
            throw new RemoteException("No such deployment id and code: id=" + req.getDeploymentId() + ": code=" + req.getDeploymentCode());
        }
        req.setDeploymentCode(idCode);
        if (req.getDeploymentCode() < 0 || req.getDeploymentCode() >= this.deployments.length) {
            throw new RemoteException("Invalid deployment id and code: id=" + req.getDeploymentId() + ": code=" + req.getDeploymentCode());
        }
        info = this.deployments[req.getDeploymentCode()];
        if (info == null) {
            throw new RemoteException("The deployement with this ID is null");
        }
        return info;
    }

    public int getDeploymentIndex(DeploymentInfo deployment) {
        return this.getDeploymentIndex((String)deployment.getDeploymentID());
    }

    public int getDeploymentIndex(String deploymentID) {
        Integer idCode = (Integer)this.index.get(deploymentID);
        return idCode == null ? -1 : idCode;
    }

    public DeploymentInfo getDeployment(String deploymentID) {
        return this.getDeployment(this.getDeploymentIndex(deploymentID));
    }

    public DeploymentInfo getDeployment(Integer index) {
        return index == null ? null : this.getDeployment((int)index);
    }

    public DeploymentInfo getDeployment(int index) {
        return this.deployments[index];
    }
}

